
# line 2 "/home/ftp/sdm/src/udape/udunits/parser.y"
/*
 * yacc(1)-based parser for decoding formatted units(3) specifications.
 */

/*LINTLIBRARY*/

#ifndef lint
    static char rcsid[] = "$Id: parser.y,v 1.6 1992/01/06 15:26:35 steve Exp $";
    static char afsid[] = "$__Header$";
#endif

#include <udposix.h>
#include <string.h>
#include "udalloc.h"
#include "uderrmsg.h"
#include "udunits.h"
#include "scanner.h"
#include "utprivate.h"

#define	malloc		udmalloc
#define realloc		udrealloc

int	UtLineno;		/* input-file line index */
int	UnitNotFound;		/* parser didn't find unit */
char	*buffer;                /* input-string buffer */
char	*pointer;               /* position in input buffer */
utUnit	*FinalUnit;		/* fully-parsed specification */

static void	yyerror();


# line 34 "/home/ftp/sdm/src/udape/udunits/parser.y"
typedef union  {
    double	rval;			/* floating-point numerical value */
    int		ival;			/* integer numerical value */
    char	name[UT_NAMELEN];	/* name of a quantity */
    utUnit	unit;			/* "unit" structure */
} YYSTYPE;
# define INT 257
# define ERR 258
# define END 259
# define SHIFT 260
# define SPACE 261
# define MULTIPLY 262
# define DIVIDE 263
# define EXPONENT 264
# define REAL 265
# define NAME 266
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 171 "/home/ftp/sdm/src/udape/udunits/parser.y"


/*
 *  YACC error routine:
 */
    static void
yyerror(s)
    char        *s;
{
    char	buf[512];
    register	i;

    udadvise("utParseSpec: %s:", s);
    udadvise(buffer);
    if (strlen(buffer) < sizeof(buf)) {
	for (i = 0; buffer+i+1 < pointer; ++i)
	    buf[i]	= ' ';
	buf[i]		= '^';
	buf[i+1]	= 0;
	udadvise(buf);
    }
}
int yyexca[] ={
-1, 0,
	0, 1,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 30
# define YYLAST 244
int yyact[]={

    13,    39,    13,    14,    23,     6,     6,     7,     7,    18,
    17,    15,    13,    38,    34,    13,    11,     6,    42,     7,
    27,     4,     6,    32,     7,     8,     1,     5,     2,    12,
    10,    20,    19,    24,     9,    33,     0,     0,     0,     0,
    36,    28,     0,     0,    35,    20,     0,    30,    31,     0,
    29,    36,    41,     0,    20,    35,     0,     0,    40,    37,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    14,     3,    14,
    26,     0,    21,    22,     0,    15,    16,    15,    16,    14,
     0,    14,    14,     0,    21,    22,    26,    15,    16,    15,
    15,    16,     0,    25 };
int yypact[]={

   -38, -1000,  -249,  -250,   -25,   -28, -1000, -1000,  -256,   -21,
 -1000, -1000, -1000,   -25, -1000, -1000,   -37, -1000, -1000,   -28,
  -256,   -25,   -25,   -26, -1000,   -37, -1000,  -244,   -40, -1000,
  -256,  -256, -1000, -1000,   -26,  -254, -1000, -1000, -1000, -1000,
   -23, -1000, -1000 };
int yypgo[]={

     0,    20,    33,    16,    35,    23,    25,    34,    30,    29,
    28,    27,    26 };
int yyr1[]={

     0,    12,    12,    12,    10,    10,    11,    11,    11,    11,
     6,     6,     7,     7,     7,     8,     8,     8,     9,     9,
     5,     5,     4,     4,     2,     2,     1,     1,     3,     3 };
int yyr2[]={

     0,     1,     5,     5,     5,     3,     3,     5,     7,     7,
     3,     7,     3,     5,     7,     3,     3,     7,     3,     5,
     3,     7,     5,     3,     3,     5,     3,     3,     3,     3 };
int yychk[]={

 -1000,   -12,   -10,   256,    -1,   -11,    43,    45,    -6,    -7,
    -8,    -3,    -9,    40,   257,   265,   266,   259,   259,   -11,
    -6,   262,   263,   260,    -2,   264,   257,    -1,   -11,    -2,
    -6,    -6,    -5,    -4,    40,    -1,    -3,    -2,   257,    41,
    -5,    -3,    41 };
int yydef[]={

    -2,    -2,     0,     0,     0,     5,    26,    27,     6,    10,
    12,    15,    16,     0,    28,    29,    18,     2,     3,     4,
     7,     0,     0,     0,    13,     0,    24,     0,     0,    19,
     8,     9,    11,    20,     0,     0,    23,    14,    25,    17,
     0,    22,    21 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"INT",	257,
	"ERR",	258,
	"END",	259,
	"SHIFT",	260,
	"SPACE",	261,
	"MULTIPLY",	262,
	"DIVIDE",	263,
	"EXPONENT",	264,
	"REAL",	265,
	"NAME",	266,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"unit_spec : /* empty */",
	"unit_spec : s_unit_exp END",
	"unit_spec : error END",
	"s_unit_exp : sign unit_exp",
	"s_unit_exp : unit_exp",
	"unit_exp : shift_exp",
	"unit_exp : unit_exp shift_exp",
	"unit_exp : unit_exp MULTIPLY shift_exp",
	"unit_exp : unit_exp DIVIDE shift_exp",
	"shift_exp : power_exp",
	"shift_exp : shift_exp SHIFT value_exp",
	"power_exp : factor_exp",
	"power_exp : power_exp s_integer",
	"power_exp : power_exp EXPONENT s_integer",
	"factor_exp : number_exp",
	"factor_exp : quant_exp",
	"factor_exp : '(' unit_exp ')'",
	"quant_exp : NAME",
	"quant_exp : NAME s_integer",
	"value_exp : s_number_exp",
	"value_exp : '(' value_exp ')'",
	"s_number_exp : sign number_exp",
	"s_number_exp : number_exp",
	"s_integer : INT",
	"s_integer : sign INT",
	"sign : '+'",
	"sign : '-'",
	"number_exp : INT",
	"number_exp : REAL",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 66 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			YYACCEPT;
		  } break;
case 2:
# line 69 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-1].unit, FinalUnit);
			YYACCEPT;
		  } break;
case 3:
# line 73 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ 
			yyerrok;
			yyclearin;
			YYABORT;
		  } break;
case 4:
# line 80 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ 
			(void)utScale(&yypvt[-0].unit, yypvt[-1].ival < 0 ? -1.0 : 1.0, &yyval.unit);
		  } break;
case 5:
# line 83 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-0].unit, &yyval.unit);
		  } break;
case 6:
# line 88 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-0].unit, &yyval.unit);
		  } break;
case 7:
# line 91 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utMultiply(&yypvt[-1].unit, &yypvt[-0].unit, &yyval.unit);
		  } break;
case 8:
# line 94 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utMultiply(&yypvt[-2].unit, &yypvt[-0].unit, &yyval.unit);
		  } break;
case 9:
# line 97 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utDivide(&yypvt[-2].unit, &yypvt[-0].unit, &yyval.unit);
		  } break;
case 10:
# line 102 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-0].unit, &yyval.unit);
		  } break;
case 11:
# line 105 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utShift(&yypvt[-2].unit, yypvt[-0].rval, &yyval.unit);
		  } break;
case 12:
# line 110 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-0].unit, &yyval.unit);
		  } break;
case 13:
# line 113 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utRaise(&yypvt[-1].unit, yypvt[-0].ival, &yyval.unit);
		  } break;
case 14:
# line 116 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utRaise(&yypvt[-2].unit, yypvt[-0].ival, &yyval.unit);
		  } break;
case 15:
# line 121 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			utUnit	unit;
			(void)utScale(utClear(&unit), yypvt[-0].rval, &yyval.unit);
		  } break;
case 16:
# line 125 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-0].unit, &yyval.unit);
		  } break;
case 17:
# line 128 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			(void)utCopy(&yypvt[-1].unit, &yyval.unit);
		  } break;
case 18:
# line 133 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ 
			utUnit     unit;
			if (utFind(yypvt[-0].name, &unit) != 0) {
			    UnitNotFound	= 1;
			    YYERROR;
			}
			(void)utCopy(&unit, &yyval.unit);
		  } break;
case 19:
# line 141 "/home/ftp/sdm/src/udape/udunits/parser.y"
{
			utUnit     unit;
			if (utFind(yypvt[-1].name, &unit) != 0) {
			    UnitNotFound	= 1;
			    YYERROR;
			}
			(void)utRaise(&unit, yypvt[-0].ival, &yyval.unit);
		  } break;
case 20:
# line 151 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-0].rval; } break;
case 21:
# line 152 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-1].rval; } break;
case 22:
# line 155 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-1].ival*yypvt[-0].rval; } break;
case 23:
# line 156 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-0].rval; } break;
case 24:
# line 159 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.ival = yypvt[-0].ival; } break;
case 25:
# line 160 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.ival = yypvt[-1].ival < 0 ? -yypvt[-0].ival : yypvt[-0].ival; } break;
case 26:
# line 163 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.ival =  1; } break;
case 27:
# line 164 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.ival = -1; } break;
case 28:
# line 167 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-0].ival; } break;
case 29:
# line 168 "/home/ftp/sdm/src/udape/udunits/parser.y"
{ yyval.rval = yypvt[-0].rval; } break;
	}
	goto yystack;		/* reset registers in driver code */
}
