/*
 * $Id: udstring.c,v 2.4 1991/04/10 19:38:33 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include "udres.h"
#include "uderrmsg.h"

extern char	*udstrdup();


/*
 * Convert a string.
 */
int
UdString(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		status	= 1;

    if (mode == UD_MNEMONIC) {
	assert(str != NULL);

	*(char**)str	= "string";

    } else if (mode == UD_POINTER) {
	assert(str != NULL);
	assert(bin != NULL);

	*(char***)bin	= (char**)str;

    } else if (mode == UD_BIN_SIZE) {
	status	= sizeof(char*);

    } else if (mode == UD_TO_STRING) {
	assert(bin != NULL);

	*(char**)str	= udstrdup(*(char**)bin);

    } else if (mode == UD_TO_BINARY) {
	if (bin != NULL)
	    *(char**)bin	= str == NULL
						? NULL
						: udstrdup((char*)str);

    } else {
	status	= 0;
    }

    return status;
}
