/*
 * $Id: udoutfile.c,v 1.8 1992/01/24 16:47:50 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "udres.h"
#include "uderrmsg.h"
#include "udpath.h"
#include "udalloc.h"


/*
 * Convert an output file.  If the file exists, determine if it's writable.
 * If the file doesn't exist, determine if its parent directory is
 * writable.
 */

    int
UdOutFile(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		success	= 1;		/* Routine status = success */
    static char	me[]	= "UdOutFile";

    if (success = UdString(str, bin, mode)) {

	if (mode == UD_MNEMONIC) {
	    *(char**)str	= "OutFile";

	} else if (mode == UD_TO_BINARY && str != NULL) {
	    int		type, accessmode;

	    success	= 0;			/* Make success an exception */

	    if (strcmp((char*)str, "-") == 0) {
		if (fdopen(1, "w") == (FILE*)0) {
		    udadvise("%s: Can't open standard output \"-\".", me);
		} else {
		    success	= 1;
		}
	    } else {
		if (!udpath((char*)str, &type, &accessmode)) {
		    /*
		     * Can't access file.  See if the parent directory is
		     * writable.
		     */
		    char	*dir	= udhead((char*)str);

		    success	= UdOutDir((VOIDP)dir, (VOIDP)NULL, mode);
		    /*
		     * The following line might cause lint(1) to emit a warning
		     * about "possible pointer alignment".  This may safely be
		     * ignored.
		     */
		    FREE(dir);

		} else if (type != UD_FREG && 
			   type != UD_FCHR &&
			   type != UD_FBLK &&
			   type != UD_FFIFO) {
		    udadvise("%s: \"%s\" is not file-like.", me, (char*)str);
		} else if (!(accessmode & UD_FWRITE)) {
		    udadvise("%s: Output file \"%s\" is not writeable.", me, 
			(char*)str);
		} else {
		    success	= 1;
		}
	    }
	}
    }

    return success;
}
