/*
 * $Id: udbool.c,v 2.5 1991/06/28 16:17:51 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "udres.h"
#include "uderrmsg.h"

extern char	*udstrdup();

typedef struct {
    char	*bname;		/* string to match against */
    int		bval;		/* value to use */
}   BoolEntry;

static BoolEntry	BoolTab[] = {
    {"yes",	1},
    {"no",	0},
    {"true",	1},
    {"false",	0},
    {"on",	1},
    {"off",	0},
    {"set",     1},
    {"unset",   0},
    {"1",	1},
    {"0",	0},
    (char *) NULL
};


/*
 * Convert a boolean.
 */
int
UdBool(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		status	= 1;
    static char	me[]	= "UdBool";

    if (mode == UD_MNEMONIC) {
	*(char**)str	= "bool";

    } else if (mode == UD_POINTER) {
	*(int**)bin	= (int*)str;

    } else if (mode == UD_BIN_SIZE) {
	status	= sizeof(int);

    } else if (mode == UD_TO_STRING) {
	*(char**)str	= udstrdup(*(int*)bin ? "true" : "false");

    } else if (mode == UD_TO_BINARY) {
	if (str == NULL || *(char*)str == 0) {	/* Default action */
	    if (bin != NULL)
		*(int*)bin	= 1;
	} else {
	    BoolEntry	*bb;

	    /* Search for a match in the table */
	    for (bb = BoolTab; bb->bname != NULL; ++bb) {
		register char	*s	= (char*)str;
		register char	*n	= bb->bname;

		for (; *s != 0 && *n != 0; ++s, ++n)
		    if (*s != *n && tolower(*s) != *n)
			break;

		if (*s == 0 && *n == 0)
		    break;
	    }

	    if (bb->bname == NULL) {
		udadvise("%s: \"%s\" is an invalid boolean.", me, (char*)str);
		status	= 0;
	    } else {
		*(int*)bin	= bb->bval;
	    }
	}

    } else {
	status	= 0;
    }

    return status;
}
