/*
 * $Id: stringlist.c,v 2.8 1992/01/24 16:46:47 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stddef.h>		/* for size_t (for "udalloc.h") and NULL */
#include <string.h>
#include "udalloc.h"
#include "uderrmsg.h"


/*
 * Create a string-list.
 */
char**
SlCreate(num)
    int		num;
{
    int		i;
    char	**list	= UD_ALLOC(num, char*);
    static char	me[]	= "SlCreate";

    if (list == NULL) {
	udadvise("%s: Couldn't allocate %u-element list.", me, num);
    } else {
	for (i = 0; i < num; ++i)
	    list[i]	= NULL;
    }

    return list;
}


/*
 * Free a string-list.
 */
void
SlFree(num, list)
    char	**list;
{
    if (list != NULL) {
	int	i;

	for (i = 0; i < num; ++i)
	    if (list[i] != NULL)
		/*
		 * The following line might cause lint(1) to emit a warning
		 * about "possible pointer alignment".  This may safely be
		 * ignored.
		 */
		(void)FREE(list[i]);
    }
}
