/*
 * $Id: dectab.h,v 2.1 1991/04/10 14:45:04 steve Exp $
 *
 * $__Header$
 *
 * This file contains public and private declarations for the decode-table
 * abstract data type.
 *
 * REQUIRES:
 *	Definition of the PROTO() macro (e.g. from "udposix.h").
 */

#ifndef UD_DECTAB_H_INCLUDED
#define UD_DECTAB_H_INCLUDED

typedef struct DtTag	*DtPtr;		/* NB: incomplete type */

/*
 * Interface to decode-table abstract data type:
 */
extern DtPtr		DtCreate	PROTO((UdKeyEntry *ke, UdPosEntry *pe));
extern int		DtKeyFind	PROTO((DtPtr dtp, char *name));
extern int		DtPosFind	PROTO((DtPtr dtp));
extern void		DtReset		PROTO((DtPtr dtp));
extern int		DtNextKey	PROTO((DtPtr dtp));
extern int		DtNextPos	PROTO((DtPtr dtp));
extern int		DtNextPar	PROTO((DtPtr dtp));
extern int		DtNval		PROTO((DtPtr dtp));
extern char*		DtName		PROTO((DtPtr dtp));
extern int		DtNleave	PROTO((DtPtr dtp));
extern UdConverter*	DtFunct		PROTO((DtPtr dtp));
extern VOIDP		DtWhere		PROTO((DtPtr dtp));
extern int*		DtCount		PROTO((DtPtr dtp));
extern int		DtWasError	PROTO((DtPtr dtp));
extern void		DtFree		PROTO((DtPtr dtp));

#endif	/* !UD_DECTAB_H_INCLUDED */
