/*
 * $Id: udposix.h,v 1.2 1991/06/28 16:57:21 steve Exp $
 * $__Header$
 *
 * Configuration header-file for the Ultrix 4.0 version of the Unidata 
 * POSIX programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

#ifndef	POSIX
#   define	POSIX
#endif
#ifndef	_POSIX_SOURCE
#   define	_POSIX_SOURCE
#endif

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

typedef	int		bool;
#define	NO		0
#define	YES		1
#define FREE_ARG	char*			/* argument to free(3) */
typedef void		*VOIDP;
typedef void		*voidp;

/*
 *	Compiler-dependent, ANSI-C symbols:
 *
 *	The PROTO() Macro is for declaring functions regardless of the 
 *	availability of function prototypes.  It will need double parens
 *	in actual use (e.g.  "int func PROTO((int a, char *cp))").
 */
#if defined(__STDC__) || defined(__GNUC__) \
    || defined(__cplusplus) || defined(c_plusplus)
#   define	PROTO(a)	a
#   define	GLUE(a,b)	a##b
#   define	MAKESTRING(s)	# s
#else
#   define	PROTO(a)	()
#   define	signed
#   define	GLUE(a,b)	a/**/b
#   define	MAKESTRING(s)	"s"
#   define	const
#endif

#endif	/* UDPOSIX_H_INCLUDED not defined */
