/*
 * $Id: stdlib.h,v 1.7 1991/04/10 23:20:48 steve Exp $
 * $__Header$
 *
 * <stdlib.h> header-file for the SunOS 4.0.3 version of the Unidata POSIX
 * programming environment.
 *
 * REQUIRES:
 *	Definition for PROTO() macro (e.g. in "udposix.h").
 *	Definition for VOIDP (e.g. in "udposix.h").
 *	Definition for NULL macro.
 */

#ifdef UDPOSIX_H_INCLUDED

#ifndef	UD_STDLIB_H_INCLUDED
#define	UD_STDLIB_H_INCLUDED

/*
 *	Include appropriate implementation-supplied header files.
 */
#include <malloc.h>		/* for calloc(), malloc(), realloc(), and */
				/* free() */

extern double	atof	PROTO((const char *s));
extern int	atoi	PROTO((const char *s));
extern long	atol	PROTO((const char *s));
extern double	strtod	PROTO((const char *s, char **endp));
extern long	strtol	PROTO((const char *s, char **endp, int base));
extern unsigned long
		strtoul	PROTO((const char *s, char **endp, int base));
extern int	rand	PROTO((void));
extern void	srand	PROTO((unsigned int seed));
#if 0
extern void    *calloc	PROTO((size_t nobj, size_t size));
extern void    *malloc	PROTO((size_t size));
extern void    *realloc PROTO((void*p, size_t size));
extern void	free	PROTO((void *p));
#endif
extern void	abort	PROTO((void));
extern void	exit	PROTO((int status));
#   define	EXIT_SUCCESS	0
#   define	EXIT_FAILURE	1
extern int	system	PROTO((const char *s));
extern char    *getenv	PROTO((const char *name));
extern void    *bsearch PROTO((const void *key, const void *base,
			       size_t n, size_t size,
			       int (*cmp)(const void *keyval,
					  const void *datum)));
extern void	qsort	PROTO((void *base, size_t n, size_t size,
			       int (*cmp)(const void *, const void *)));
extern int	abs	PROTO((int n));

#define	labs(i)		((long)abs(i))
#define	atexit(f)	(void)on_exit(f, (VOIDP)NULL)

/*
 *	The following functions don't appear to exist in the library:
 *
 *	unsigned long	strtoul	PROTO((const char *s, char **endp, int base));
 *	div_t		div	PROTO((int num, int denom));
 *	ldiv_t		ldiv	PROTO((long num, long denom));
 */

#endif	/* UD_STDLIB_H_INCLUDED not defined */

#endif	/* UDPOSIX_H_INCLUDED defined */
