/*
 * $Id: limits.h,v 1.1 1992/04/28 14:45:05 steve Exp $
 *
 * <limits.h> header-file for the DomainOS 10.3.2 version of
 * the Unidata applications programming environment (UDAPE). 
 * DomainOS 10.3.2 BSD4.3 doesn't have <limits.h> .
 */

#ifdef UDPOSIX_H_INCLUDED

#ifndef	UD_LIMITS_H_INCLUDED
#define	UD_LIMITS_H_INCLUDED

/*
 * POSIX Table 2.2
 */
#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512

/*
 * POSIX Table 2.3
 * max # of simultaneous supplementary group IDs per process.
 * Actual limit may be higher, use sysconf() to get correct value.
 */
#define	NGROUPS_MAX	 0

/*
 * POSIX Table 2.4
 */
#define ARG_MAX		10240
/* CHILD_MAX is indeterminate, and therefore omited here. */
#define OPEN_MAX	128

/*
 * POSIX Table 2.5
 */
#define LINK_MAX	65535
#define MAX_CANON	_POSIX_MAX_CANON
#define MAX_INPUT	_POSIX_MAX_INPUT
#define NAME_MAX	255
#define PATH_MAX	1023
#define PIPE_BUF	5120

/*
 * Standard C
 */
#define CHAR_BIT	 8
#define CHAR_MAX	 127
#define CHAR_MIN	 -128
#define INT_MAX		 2147483647
#define INT_MIN		-2147483648
#define LONG_MAX	 INT_MAX
#define LONG_MIN	 INT_MIN
#define SCHAR_MAX	 127
#define SCHAR_MIN	-128
#define SHRT_MAX	 32767
#define SHRT_MIN	-32768
#define UCHAR_MAX	 255
#define UINT_MAX	 4294967295
#define ULONG_MAX	 4294967295
#define USHRT_MAX	 65535

#endif	/* UD_LIMITS_H_INCLUDED not defined */

#endif	/* UDPOSIX_H_INCLUDED defined */
