/*
 * $Id: stdlib.h,v 1.1 1992/04/28 14:38:25 steve Exp $
 * $__Header$
 *
 * <stdlib.h> header-file for the DomainOS 10.2 version of
 * the Unidata POSIX programming environment.
 * DomainOS 10.2 BSD4.3 doesn't have <stdlib.h> .
 */

#ifdef UDPOSIX_H_INCLUDED

#ifndef	UD_STDLIB_H_INCLUDED
#define	UD_STDLIB_H_INCLUDED

/*
 *	Handle missing symbols that need definitions.
 */
#include <sys//types.h>	/* for size_t */
extern double strtod PROTO((char *s, char **endp));
extern char	*alloca	 PROTO((int size));
extern char	*calloc	 PROTO((unsigned nelem, unsigned size));
extern char	*malloc	 PROTO((unsigned size));
extern char *realloc PROTO((char *ptr, unsigned size));
extern void	free	 PROTO((char *ptr));
extern void	abort	 PROTO((void));
extern void	exit	 PROTO((int status));
extern char	*getenv	 PROTO((char *name));
extern char	*bsearch PROTO((char *key, char *base, unsigned n,
			    unsigned size, int (*cmp)()));

#define	labs(i)	((long)abs(i))
#define	EXIT_SUCCESS	0
#define	EXIT_FAILURE	1

#endif	/* !UD_STDLIB_H_INCLUDED */

#endif	/* UDPOSIX_H_INCLUDED defined */
