/*
 * $Id: udstderr.h,v 1.1 1992/04/28 14:30:56 steve Exp $
 *
 * (C) Copyright 1992 UCAR/Unidata
 *  
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose without fee is hereby granted,
 * provided that the above copyright notice appear in all copies, that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of UCAR/Unidata not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  UCAR makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.  It is provided with no support and without obligation on
 * the part of UCAR or Unidata, to assist in its use, correction,
 * modification, or enhancement.
 * 
 * This file is the header-file for the UDAPE standard-error handler.
 *
 * NB: I'd like to use the prefix `E' for this package, but all such
 * words are reserved by the C standard if <errno.h> is included.  
 */

#ifdef UD_FORTRAN_SOURCE
#   undef	UDSTDERR_HEADER_SEEN
#endif

#ifndef UDSTDERR_HEADER_SEEN
#   define UDSTDERR_HEADER_SEEN

#   include "udposix.h"

    /*
     * Message causes:
     */
#   ifndef SE_NONE
#      define SE_NONE   0       /* because I felt like it */
#      define SE_SYSTEM 1       /* operating-system error */
#      define SE_SUB    2       /* failure in lower-level package */
#      define SE_LOWER  SE_SUB
#      define SE_USAGE  4       /* improper usage */
#      define SE_STATE  8       /* inconsistent internal state */
#   endif

    /*
     * Message levels:
     */
#   ifndef SE_DEBUG
#      define SE_DEBUG   1      /* diagnostic message for debugging */
#      define SE_INFO    2      /* informational message; nothing special */
#      define SE_NOTICE  4      /* some special user-action might be required */
#      define SE_WARN    8      /* something might be wrong; processing will */
                                /* continue, however */
#      define SE_WARNING SE_WARN
#      define SE_ERROR  16      /* a failure of some sort */
#   endif

#if 0
    /*
     * Message classes:
     */
#   ifndef SE_DEBUG
#      define SE_DEBUG    1     /* diagnostic message for debugging */
#      define SE_INFO     2     /* informational message; nothing special */
#      define SE_NOTICE   4     /* some special user-action might be required */
#      define SE_WARNING  8     /* something might be wrong; processing will */
                                /* continue */
#      define SE_WARN     SE_WARNING
#      define SE_SEVERE  16     /* goal cannot be attained; processing will */
                                    /* continue */
#      define SE_FATAL   32     /* goal cannot be attained; processing will */
                                    /* not continue */
#      define SE_SYSTEM  64     /* operating-system error */
#      define SE_ALWAYS 128     /* always print message */
#   endif
#endif

    /*
     * Behavioral modes:
     */
#   ifndef SE_VERBOSE
#      define SE_VERBOSE 1
#      define SE_ABORT   2
#   endif

#   define SE_ENTER(name)               se_entry  = name

#   ifdef UD_FORTRAN_SOURCE

        /*
         * The following subroutines should be used from FORTRAN:
         *      if (seinit(character*(*) program) .ne. 0) <error>
         *      nchar = seprint(character*(*) package, character*(*) routine, 
         * &            int *class, character*(*) msg)
         *      if (seflush() .ne. 0) <error>
         */

        /*
         * Convert the convenient FORTRAN routine-names to the actual names 
         * of the FORTRAN interface.
         */
#       ifndef seinit
#           define seinit  sefinit
#           define seprint sefprint
#           define seflush sefflush
#       endif

#	define SE_ENTRY(name)	character*33 se_entry /name/
#	define SE_ROUTINE(name)	character*33 se_routine /name/

#   else        /* UD_FORTRAN_SOURCE not defined below */

        /*
         * C API:
         */
        EXTERN_FUNC(int  seInit,     (const char *progname));
        EXTERN_FUNC(void seIdentify, (const char *package, 
                                      const char *entry,
                                      const char *routine));
        EXTERN_FUNC(int  sePrint,    (int cause, int level, const char *fmt, 
				      ...));
        EXTERN_FUNC(int  seFlush,    (void));
        EXTERN_FUNC(void seTerm,     (void));

        static const char     *se_entry;

#       define  SE_ROUTINE(name)        static char se_routine[] = name
#	define	SE_ENTRY(name)		const char *se_routine = \
						se_entry = name;
#       define  SE_PRINT(args)          UD_STMT( \
            seIdentify(SE_PACKAGE, se_entry, se_routine); \
            (void) sePrint args; \
        )

#   endif /* UD_FORTRAN_SOURCE not defined above */

#endif /* UDSTDERR_HEADER_SEEN not defined above */


/* ex: se wm=0: */
