/*
 * $Id: uderrmsg.h,v 1.8 1992/04/27 17:24:10 steve Exp $
 *
 * $__Header$
 */

#ifndef UD_ERROR_H_INCLUDED
#define UD_ERROR_H_INCLUDED

#ifndef UD_FORTRAN_SOURCE

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#ifndef	PROTO
#   if defined(__STDC__) || defined(__GNUC__) || defined(__cplusplus) || defined(c_plusplus)
#	define	PROTO(a)	a
#   else
#	define	PROTO(a)	()
#   endif
#endif

#if defined(__cplusplus) || defined(c_plusplus)
   extern "C" {
#endif

extern int	uderrmode	PROTO((const int mode));
extern char*	uderrname	PROTO((const char *name));
extern void	uderror		PROTO((const char *fmt, ...));
extern int	udverror	();
extern void	udadvise	PROTO((const char *fmt, ...));
extern int	udvadvise	();
extern char*	udtime_stamp	PROTO((void));

#if defined(__cplusplus) || defined(c_plusplus)
   }
#endif

#endif	/* UD_FORTRAN_SOURCE not defined above */


/*
 * Global options variable. Used to control behavior of error handler.
 */
#define	UD_FATAL	1
#define	UD_VERBOSE	2


#endif	/* !UD_ERROR_H_INCLUDED */
