/*
 * ex: se wm=0:
 *
 * $Id: udalloc.h,v 2.4 1992/04/27 17:18:00 steve Exp $
 */

#ifndef UD_ALLOC_H_INCLUDED
#define UD_ALLOC_H_INCLUDED

#include <stdlib.h>

/*
 *	Interface to the Unidata memory-allocation abstraction:
 */
EXTERN_FUNC(VOIDP	udmalloc,	(size_t nbytes));
EXTERN_FUNC(VOIDP	udrealloc,	(VOIDP ptr, size_t nbytes));
EXTERN_FUNC(char	*udstrdup,	(const char *s));
EXTERN_FUNC(char	*udstrndup,	(const char *s, size_t nbytes));
EXTERN_FUNC(size_t	*udfortlen,	(const char *s, int max));


/*
 *	Some macros to make life easier:
 */
#define UD_ALLOC(theNum, theType) \
	    (theType*)udmalloc((size_t)(sizeof(theType)*(theNum))) 

#define UD_REALLOC(ptr, theNum, theType) \
	    (theType*)udrealloc((VOIDP)(ptr), \
		    (size_t)(sizeof(theType)*(theNum)))

#define FREE(ptr)		(void)free((FREE_ARG)(ptr))

#endif	/* !UD_ALLOC_H_INCLUDED */
