/*
 * ex: se wm=0:
 *
 * Copyright (C) 1991 UCAR/Unidata
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose without fee is hereby granted, provided that
 * the above copyright notice appear in all copies, that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of UCAR/Unidata not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission.  UCAR makes no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.  It is provided with no support and without obligation
 * on the part of UCAR or Unidata, to assist in its use, correction,
 * modification, or enhancement.
 * 
 * $Id: linklist.h,v 1.1 1992/04/28 14:30:07 steve Exp $
 */

/*
 * This file describes the public portion of the linked-list abstraction.
 */

#ifndef	LINKLIST_H_INCLUDED
#   define	LINKLIST_H_INCLUDED

    /*
     * Opaque, linked-list datatype:
     */
    struct Linklist;
    typedef struct Linklist Linklist;

    /*
     * Linked-list API:
     */
    EXTERN_FUNC(Linklist *llnew,   (void));
    EXTERN_FUNC(voidp     lladd,   (Linklist *list, const voidp data, 
				     size_t size));
    EXTERN_FUNC(voidp     llfirst, (Linklist *list));
    EXTERN_FUNC(voidp     llnext,  (Linklist *list));
    EXTERN_FUNC(Linklist *llfree,  (Linklist *list));

#endif	/* LINKLIST_H_INCLUDED was not defined above */
