c-----------------------------------------------------------------------
      subroutine write_file(FULL)
c-----------------------------------------------------------------------
c
c     When invoked, this subroutine will write in a file the current
c     coordinates in a format suitable to be read by itself.
c
      parameter (natom = 10000) 
      parameter (nbond = 50000) 
c 
      character*80 string,filename
      character*4 atlabel
      integer curr_atom,curr_mol,table,atomi,atomj,action
      logical wireframe,ball_and_stick,need_sort,label_num,
     &        label_cha,need_lim,perspective,round_bonds,
     &        autoscl,showhb,havehb
      logical display,line_dis,arrow_dis,arc_dis,show_atom
      logical FULL, changed_mol
c
      dimension table(natom)
c
      common/draw_spec/rad_fact,bond_fact,top_z,bottom_z
      common/draw_log/wireframe,ball_and_stick,need_sort,label_num,
     &                label_cha,need_lim,perspective,round_bonds,
     &                autoscl,showhb,havehb
      common/mol_num/numat,num(natom),co(3,natom),atrad(natom)
      common/multi_mol/mol_numat(100),num_mol
      common/mol_char/atlabel(natom)
      common/show/show_atom(natom)
      common/other_bonds/initial,mod_bonds(nbond)
      common/useratt/user_scale
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &                    next_line,idash(40),iwid(40)
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
      common/arcs/arc_dis(40),x1a(40),y1a(40),x2a(40),y2a(40),
     &            x3a(40),y3a(40),cx(40),cy(40),r(40),next_arc,
     &            idasha(40),iwida(40)
      common/font_num/ifont
c
      read(*,1002) filename
      open(22,file=filename,err=666,status='unknown')
      write(22,1003) rad_fact,bond_fact
      curr_atom=0
      curr_mol = 1
      last_atom = numat
      if (num_mol.gt.1) last_atom = mol_numat(1)
      do i=1,numat
         if (show_atom(i)) then
            changed_mol = i.gt.last_atom
            curr_atom=curr_atom+1
            table(i)=curr_atom
            if (changed_mol) then
               curr_mol  = curr_mol+1
               last_atom = last_atom+mol_numat(curr_mol)
               write(22,*) '% SuperImposed'
            endif
            write(22,1004) num(i),(co(j,i),j=1,3),atlabel(i)
         endif
      enddo
      if(.not. FULL) then
         close(22)
         write(*,1005) filename
         call flush(6)
         return
      endif
c
c Write out the saved state.
c
      if (next_string.gt.1) then
         do i=1,next_string-1
            if (display(i)) then
               write(22,*) '$add label ',x_string(i),y_string(i),
     &                             angle(i),height(i),len_string(i)
               write(22,*) '$'//string(i)(1:len_string(i))
            endif
         enddo
      endif
      if (next_line.gt.1) then
         do i=1,next_line-1
            if (line_dis(i)) write(22,*) '$add line ',x1(i),y1(i),
     &                                    x2(i),y2(i),idash(i),iwid(i)
         enddo
      endif
      if (next_head.gt.1) then
         do i=1,next_head-1
            if (arrow_dis(i)) write(22,*) '$add arrow ',xb(i),yb(i),
     &                                     xe(i),ye(i)
         enddo
      endif
      if (next_arc.gt.1) then
         do i=1,next_arc-1
            if (arc_dis(i)) then
               write(22,*) '$add arc ',x1a(i),y1a(i),x2a(i),y2a(i),
     &                             x3a(i),y3a(i)
               write(22,*) '$',cx(i),cy(i),r(i),idasha(i),iwida(i)
            endif
         enddo
      endif
      if (ball_and_stick) write(22,*) '$set model ball'
      if (perspective) write(22,*) '$set proj persp'
      if (label_cha) write(22,*) '$set label characters'
      if (label_num) write(22,*) '$set label numbers'
      if (round_bonds) write(22,*) '$set bonds rounded'
      if (user_scale.ne.1.0) write(22,*) '$set scale ',user_scale
      if (ifont.ne.0) write(22,*) '$set font ',ifont
      if (initial.gt.1) then
         do i=1,initial,3
            atomi = mod_bonds(i)
            atomj = mod_bonds(i+1)
            if (show_atom(atomi) .and. show_atom(atomj)) then
               action=mod_bonds(i+2)
               if (action.eq.-1) then
                  write(22,*) '$delete bond ',table(atomi),table(atomj)
               else if (action.eq.1) then
                  write(22,*) '$add bond ',table(atomi),table(atomj)
               else if (action.eq.2) then
                  write(22,*) '$add partial ',table(atomi),table(atomj)
               endif
            endif
         enddo
      endif
      close(22)
      write(*,1006) filename
      call flush(6)
      return
 666  call notify('Error opening file! ')
      return
 1002 format(a80)
 1003 format('Mind ',2f8.3)
 1004 format(i3,3f12.6,2x,a4)
 1005 format('Current coordinates written to ',a)
 1006 format('Current state written to ',a)
      end
c
c
c-----------------------------------------------------------------------
      subroutine notify(string)
c-----------------------------------------------------------------------
c  Write a string to the output device and flush the
c  buffer.
c
      character*80 string
c
      write(*,*) string
      call flush(6)
      return
      end
