c-----------------------------------------------------------------------
      logical function inrange(x,y,cut,bcx,bcy)
c-----------------------------------------------------------------------
c
c     will return .TRUE. if the X,Y point is within the CUT horizontal
c     distances of BCX,BCY
c
      implicit real(a-h,o-z)
c
      xmin = bcx - cut
      xmax = bcx + cut
      ymin = bcy - cut
      ymax = bcy + cut
      inrange = .false.
      if(x .lt. xmin .or. x .gt. xmax) return
      if(y .lt. ymin .or. y .gt. ymax) return
      inrange = .true.
      return
      end
c-----------------------------------------------------------------------
      logical function nearatom(x,y,atomnum)
c-----------------------------------------------------------------------
c
c     will return .TRUE. if there is an atom near the X, Y point.  In
c     addition, it will return its number in ATOMNUM.
c
      implicit real(a-h,o-z)
      parameter (natom = 10000) 
      parameter (nbond = 50000) 
c 
      integer atomnum
      logical inrange,wireframe,ball_and_stick,need_sort,label_num,
     &                label_cha,show_atom,need_lim,perspective,
     &                round_bonds,autoscl,showhb,havehb
c
      common/draw_log/wireframe,ball_and_stick,need_sort,label_num,
     &                label_cha,need_lim,perspective,round_bonds,
     &                autoscl,showhb,havehb
      common/mol_num/numat,num(natom),co(3,natom),atrad(natom)
      common/sortseq/iseq(natom),irank(natom)
      common/show/show_atom(natom)
c
      atomnum = 0
c
c     loop over all the atoms :
c
      do i = numat,1,-1
c
c        if using ball and stick search downwards from the top with a
c        cutoff equal to the radius of the current atom. In wireframe
c        search in numerical order and use a fixed cutoff
c
         if(ball_and_stick) then
            j = iseq(i)
            cut = atrad(j)
         else
            cut = 0.1
            j = i
         endif
c
c        retrieve the coordinates of the atom we are currently testing :
c
         xatom = co(1,j)
         yatom = co(2,j)
         zatom = co(3,j)
c
c        correct for perspective, if needed.
c
         if (perspective) then
              if (ball_and_stick) cut = persp(cut,co(3,j))
              xatom = persp_x(xatom,zatom)
              yatom = persp_y(yatom,zatom)
         endif
c
c        finally, test the atom if it's not hidden :
c
         if (show_atom(j)) then
              if(inrange(x,y,cut,xatom,yatom) .and. show_atom(j)) then
                   nearatom = .true.
                   atomnum = j 
                   return
              endif
          endif
      enddo
      nearatom = .false.
      return
      end 
c-----------------------------------------------------------------------
      subroutine pick_atom(atom,button)
c-----------------------------------------------------------------------
c
c     Will use the mouse positions to select an atom to hide
c
      parameter (natom = 10000) 
      parameter (nbond = 50000) 
c 
      real max_z,min_z
      integer atom,button
      logical nearatom,found
c
      common/frame/scale,xori,yori,max_z,min_z
      common/mol_num/numat,num(natom),co(3,natom),atrad(natom)
c
      found=.false.
      do while (.not.found)
           call getpoint(cox,coy,button)
           xj = cox * scale + xori
           yj = coy * scale + yori 
           found=nearatom(xj,yj,atom)
           if (.not. found) then
              call notify('Missed the atom ! ')
           endif
      enddo
      return
      end
c-----------------------------------------------------------------------
      subroutine pick_dis(num1,num2)
c-----------------------------------------------------------------------
c
c     Will use the mouse positions to select two atoms whose distance 
c     was requested.
c
      call notify('Click on an atom pair. ')
      call pick_atom(num1,ibutton)
      call notify('Click on the second atom. ')
      call pick_atom(num2,ibutton)
      return
      end
c-----------------------------------------------------------------------
      subroutine pick_ang(num1,num2,num3)
c-----------------------------------------------------------------------
c
c     Will use the positions of the mouse to select three atoms whose 
c     angle was requested.
c
      call notify('Click on three atoms that define an angle. ')
      call pick_atom(num1,ibutton)
      call notify('Click on the second atom. ')
      call pick_atom(num2,ibutton)
      call notify('Click on the third atom. ')
      call pick_atom(num3,ibutton)
      return
      end
c-----------------------------------------------------------------------
      subroutine pick_dih(num1,num2,num3,num4)
c-----------------------------------------------------------------------
c
c     will use the positions of the mouse to select four atoms whose
c     dihedral was requested
c
      call notify('Click on four atoms that define a dihedral angle. ')
      call pick_atom(num1,ibutton)
      call notify('Click on the second atom. ')
      call pick_atom(num2,ibutton)
      call notify('Click on the third atom. ')
      call pick_atom(num3,ibutton)
      call notify('Click on the fourth atom. ')
      call pick_atom(num4,ibutton)
      return
      end
c-----------------------------------------------------------------------
      subroutine pick_add_bond(num1,num2)
c-----------------------------------------------------------------------
c
c     will use the mouse positions to select two atoms between which to 
c     form a full or partial bond.
c
      call notify('Click on an atom pair. ')
      call pick_atom(num1,ibutton)
      call notify('Click on the second atom. ')
      call pick_atom(num2,ibutton)
      return
      end
c-----------------------------------------------------------------------
      subroutine pick_del_bond(num1,num2)
c-----------------------------------------------------------------------
c
c     will use the positions of the mouse to select two atoms whose bond
c     will be deleted.
c
      call notify('Click on an atom pair. ')
      call pick_atom(num1,ibutton)
      call notify('Click on the second atom. ')
      call pick_atom(num2,ibutton)
      return
      end
