.\" @(#)mindtool.l 2.4;
.TH MindTool 1L "2 June 1990" "Local" "LOCAL COMMANDS"
.SH NAME
MindTool \- Manipulate molecules and atoms for display and analysis. 
.SH SYNOPSIS
.br
.B mindtool  
.I
[ -i icon ] [ filename ]
.SH DESCRIPTION
.LP
.I MindTool 
is a tool provided for the interactive graphic manipulation of
molecules and atoms.   Currently, up to 10,000 atoms may be input.
.I MindTool
has several subwindows:
.TP 3
+
A large drawing area or canvas for molecular display (on the left).
.TP 
+
A control panel at the upper right with buttons corresponding to the
available commands available
.TP
+
A small command field for entering file names or options not provided in the
standard interface
(at the lower right).
.TP 
+
An area for status messages (at the lower left).
.LP
Inside the canvas, use the left and middle buttons
to pick atoms, the right button brings up a menu for drawing and styling 
functions. Some commands (i.e., 
.I Hide 
and 
.I Complete) 
require the user to terminate
a list of selected atoms with the middle mouse button.
.LP
.sp
.SH CONTROL PANEL
.LP
The large control panel to the right of the canvas contains many items through
which you may control 
.I MindTool.  
Some items are buttons which allow you
to initiate commands, some are text fields which you type into, and others are
choice items allowing you select a range.  Use the left button to select
items.  Most items also have a menu which you may invoke with the right button
for help.  The frame header displays the file currently loaded and the default
directory.
.LP
There is a text field at the lower right labeled either ``File:'',
``Cmd:'', ``Dir:'', or ``Label:''.  A triangular caret points to the current
type-in position.  Typing <return> in the text field enters the command. Note
that no <return> is needed for entering filenames, directory paths, or text
labels.
.LP
Each item (Button) in the control panel is described below:
.TP 12
.I Quit
Exits the program immediately, without confirmation.
.TP 
.I Save
The current display will be saved, as is, to the file named in the command
field, or if none is given, to the default filename shown
in the header.  All the commands needed to generate the display in its
current state are saved along with the structure.
.TP 
.I More
Display the next structure in the file.  Multiple structures within the same
file are separated by four dashes (----).  See INPUT FORMAT below.
.TP 
.I Draw 
Redraw the current display.  Useful when the screen gets corrupted.
.TP 
.I cd
Change the current working default directory to the directory named in the
the command field.
.TP 
.I Read
Read the file named in the command field for display.  If the file
does not exist the user is prompted to correct the name.
.TP
.I Write 
Write the current display to the file named in the command field, or to the
file name displayed in the header, if none is given.
All the atoms that are visible in the
current orientation are written.  
Note : if in zoom mode some atoms not visible will be
written to the file.  The zoom mode is only a local
graphic construct.
.TP
.I Help 
display a help window.
.TP
.I Plot 
If no filename is specified, the current display, as shown, will
be sent to the PostScript printer.  If a filename is specified at the 
``Cmd:'' prompt,  an encapsulated PostScript file will be written.
By default, the plot is in the Landscape orientation, 
however, mugs(1l) may be used on a saved PostScript file to scale, combine
multiple files, or rotate to portrait orientation.

.TP
.I Zoom 
Zoom on a portion of the display by clicking the left mouse button
and releasing, then adjust the rubber-banding box to frame the zoom portion and
click again.
.TP
.I Pan 
Actually an ``unzoom'' button.  This button will return the display to
normal view.
.TP
.I Scale 
Will scale the display by the amount given at the ``Cmd:'' prompt.  This is an
absolute scaling, rather than a cumulative factor.  If no scaling factor is
given, the autoscaling feature will be toggled [off|on].
.TP
.I Hide 
Click on an atom and hide it and its associated bonds from display.
You may select any number of atoms to hide by clicking with the left mouse
button and terminating your selection with the middle button. Note that the
last atom to be hidden must be selected with the middle mouse button.
.TP
.I Hide None 
Display all atoms previously hidden.
.TP
.I Complete 
Complete the valence of an atom by displaying all the atoms that are bonded to
it directly.  Atoms are selected with the left button and the list is
terminated with the middle button.  This option is normally used after cutting
a layer, a sphere or hiding atoms, when a complete molecule is wanted. i.e.,
cutting a sphere around a solute molecule followed by completing any solvent
molecules.
.TP
.I Stereo
Send a stereo plot to the PostScript printer.  The 
.I viewing
option is scaled for use with stereo glasses.  The
.I publication
option will produce a plot at exactly double the size needed for viewing with
stereo glasses. Note that  directions should be given to the typesetter to
scale the publication plots by 50%.
.TP
.I Grid
Produce a background grid in the display useful for aligning text.  The grid is
evenly spaced in 0.25 inch intervals. 
.TP
.I Add Full 
Clicking on two atoms will add a full bond between them.
.TP
.I Add Partial 
Adds a partial bond between the two atoms selected.
.TP
.I Delete Bond 
Deletes a bond of any type between the two atoms selected.
.TP
.I H-Bonds
Draw hydrogen bonds between pairs of atoms.  Both the acceptor and
donor atoms must be heteroatoms.  A hydrogen bond is considered formed
if the H - - - A distance is less than the cutoff (default 2.5 A), and
the D-H - - - A angle is greater than or equal to 120 degrees. Both the
distance and angle criterion may be modified, see the notes on
ADDITIONAL COMMANDS below.

.TP
.I Tell:
These buttons will tell the 
.I Distance, 
.I Angle,
.I Dihedral, 
and 
.I Number
of atom(s) in the display.
.TP
.I Rotations:
The 
.I X, 
.I Y,
and
.I Z, 
buttons are used to rotate the
display around the indicated axes in a clockwise fashion (or counterclockwise
for the negative buttons).
.TP
.I Slider bars:
The slider bars display and set the angles of rotation about the
respective axes. Click in the grey area to adjust.
.TP
.I Choice items:
.TP
.I Wireframe,  Ball-n-Stick
Set the display mode.  In 
.I Wireframe
mode, the bonds connecting the atoms are colored up to the middle point
according to the atomic
numbers.  There are 3 
.I Ball-n-Stick 
modes available, the default mode renders atoms as colored circles with
opaque white bonds.  The other modes are white balls and bonds, and
white balls with colored bonds.  See ADDITIONAL COMMANDS below.
.TP
.I Flat Bond,  Round Bound
Toggles between bonds represented by 4-point polygons and nicer looking
cylindrical bonds. The
.I Flat Bond
mode is mainly used for very large data sets.
.TP
.I Orthographic, Perspective
sets the mode of projection.
.TP
.I No Label, Symbol, Number
.I No Label
will turn off both types of labeling [default].
.I Symbol
will mark atoms with alphanumeric labels,
if these were provided in the file (up to 4 characters), or will use the
atomic symbol if no labels were given.
.I Number
will label each atom with its sequential number, as determined from the
input file.

.TP
.I Text:  
These buttons allow the user to 
.I Add, 
.I Move, 
and 
.I Delete
text that is added to the display.  To add text, enter a string at the Cmd:
prompt and click on the 
.I Add 
button.  Hold down the right mouse button in the drawing area to bring up a
menu for changing fonts, text size, and text angle. The Angstrom symbol is
given by the sequence ``\\A''.  Superscripts are denoted by the ``^'' (caret)
character immediately preceding the superscripted  character (i.e., kcal mol
^-^1).  Likewise, subscripts are given by  the ``_'' (underscore) character. 
Note that the although the Angstrom symbol, superscripts , and subscripts will
be plotted correctly on the PostScript device, they are not shown on the
canvas.
.TP
.I Draw:
These buttons 
.I Arc,
.I Line, 
.I Arrow,
and 
.I Delete 
allow the
user to draw lines, arcs, and arrow heads on the display.  These features
are also available from the menu within the canvas, in addition to other
styling features such as line widths and styles.  The
.I Arrow
button adds an arrowhead to an existing line or arc.

.SH ADDITIONAL COMMANDS
.LP
These commands may be entered in the text field.  Two character abbreviations
of all keywords are recognized and the input is free format.
.TP
.I set display normal
This is the default.  Will render the ball-and-stick display as colored circles
with white (opaque) bonds.
.TP
.I set display reversed
Will color the bonds magenta (a nice light color for the PostScript output)
and the circles white.
.TP
.I set display clear
Both bonds and circles will be white.  Useful for illustrating atom numbering
schemes.
.TP
.I set hbonds length [value]
Will change the default maximum value (2.5 A) of length a hydrogen 
bond will be considered to exist.
.TP
.I set hbonds angle [value]
Will change the default minimum angle (120 degrees) for hydrogen bond
consideration.
.TP
.I cut top [value] 
will hide the atoms in the top layer of
.I value
angstroms thickness.
.TP
.I cut bottom [value] 
will hide the atoms in the bottom layer of
.I value
angstroms thickness.
.TP
.I cut sphere [radii] at1 {at2 ...}
cuts sphere(s) of radius
.I radii
around atoms
.I at1 at2 ...  
.TP
.I cut sphere [radii] at1 to at2
cuts a sphere(s) of radius
.I radii
around ALL the atoms from
.I at1
to
.I at2,
inclusive.
For all the 
.I cut
commands, one would normally finish by using the
.I Complete
command to fill in any dangling atoms/molecules.

.SH INPUT FORMAT
.LP
The input is completely free format with the only requirement being that the
first line of the input file contains two real numbers.  By placing ``Mind''
as the first four bytes of the file, one can facilitate use of magic(5)
numbers and the file(1) command.  See the readme.filemgr file in the 
.I MindTool 
distribution directory.
The ``#'' character placed in column one of any line will cause the remainder 
of the line to be treated as a comment.  Lines starting with the ``$''
character can be used to include commands directly in the input file and
will be executed before the molecule is displayed in the screen, i. e.
``$set model ball-n-stick''
.LP
.I line #1:
Mind RADFACT BONDFACT (2F) 
.LP
.I RADFACT 
is the ratio of the displayed to the covalent radii ratio, a value of 0.3
gives a good ball-and-stick model.  
.I BONDFACT 
is the ratio of the bond thickness to the displayed atomic radius,
a value of 0.666 seems to be adequate.
.LP
.I lines #2-end: 
ATOMIC_NUMBER  X  Y  Z  LABEL (I,3F,A4)
.LP
.I LABEL 
is optional. If present, only the first 4 characters are recognized.  
The default label is the atomic symbol.
.I X, Y, Z
are the Cartesian coordinates.  Any additional character(s) in the line are
ignored.  Also, the ordering of the values is not important as long as the
first integer number in the line is the atomic number, the first
non-numeric string is the label, and the first three floating point numbers
are the cartesian coordinates in the order X, Y, and Z.

.SH EXAMPLE
.nf

Mind 0.275 0.666
# 
# s-cis Methyl Vinyl Ketone 3-21G//3-21G
#
  6   0.64889   0.30731   0.11489   C   
  8   0.64289   1.52160   0.11570   O   
  6  -0.59141  -0.48386  -0.10502   C   
  6   1.90717  -0.50133   0.33550   C   
  6  -1.74603   0.11679  -0.30768   C   
  1  -0.50123  -1.55227  -0.09077   H   
  1   2.74530   0.16333   0.48430   H   
  1   1.79088  -1.14047   1.20514   H   
  1   2.09565  -1.13781  -0.52337   H   
  1  -1.80204   1.18850  -0.31591   H   
  1  -2.65578  -0.42725  -0.46892   H   
$set model ball-n-stick
.fi

.LP
The same file can contain more than one structure.  The structures
should be separated by a line that has at least four dashes (----)
starting in column one.  The following line should contain 
.I RADFACT 
and
.I BONDFACT 
again (Mind 0.3 0.667).  The 
.I More 
command reads the next
structure in the file.  

.LP

Up to 100 structures can be 
.I SuperImposed 
by separating
the molecules with a ``%'' in column 1.  Note that 
.I RADFACT
and
.I BONDFACT
are not required after the ``%'' character.  All the superimposed molecules
will be shown in the screen simultaneously but no bonds will be made
between them.
.LP
This program was written to provide a convenient interface to a rather
useful molecular display program.  Suggestions of features and enhancements are
appreciated and will be taken under consideration when time permits.  Any bugs
should be noted and reported.
.LP
.SH SEE ALSO
sunview(1), mugs(1L)
.SH FILES
.LP
/usr/local/bin/mindtool
.LP
/usr/local/bin/mind
.br
/usr/local/bin/mugs
.br
/usr/local/icons/mindtool.icon
.SH AUTHORS
Julian Tirado-Rives
.br
James Blake
.br
Yale University
.br
Chemistry Department
.br
jim@doctor.chem.yale.edu
.br
julian@doctor.chem.yale.edu
