      subroutine add_arc
c
      logical arc_dis
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
c
      call notify('Click the endpoints then pull for curvature. ')
      call gen_arc(x1(next_arc),y1(next_arc),
     &             x2(next_arc),y2(next_arc),
     &             x3(next_arc),y3(next_arc),
     &             cx(next_arc),cy(next_arc),r(next_arc))
      call draw_arc(x1(next_arc),y1(next_arc),
     &             x3(next_arc),y3(next_arc),
     &             cx(next_arc),cy(next_arc),r(next_arc))
      arc_dis(next_arc) = .true.
      next_arc = next_arc + 1
      call notify('Arc drawn. ')
      return
      end

c
c
      subroutine init_arcs
c
      logical arc_dis
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
c
      do i = 1, 40
         arc_dis(i) = .false.
         idash(i) = 0
         iwid(i) = 1
         x1(i) = 0.0
         y1(i) = 0.0
         x2(i) = 0.0
         y2(i) = 0.0
         x3(i) = 0.0
         y3(i) = 0.0
         cx(i) = 0.0
         cy(i) = 0.0
         r(i)  = 0.0
      enddo
      next_arc = 1
      return
      end
c
c
      subroutine draw_all_arcs
c
      logical arc_dis
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
c
      do i = 1, next_arc - 1
         if(arc_dis(i)) then
            if(idash(i) .ne. 0) call setdash(idash(i))
            if(iwid(i) .ne. 1) call line_width(iwid(i))
            call draw_arc(x1(i),y1(i),x3(i),y3(i),
     &                    cx(i),cy(i),r(i))
            if(idash(i) .ne. 0) call setdash(0)
            call draw_heads(x1(i),y1(i))
            call draw_heads(x3(i),y3(i))
            if(iwid(i) .ne. 1) call line_width(1)
         endif
      enddo 
      return
      end
c
c
      subroutine delete_arc
c
      logical arc_dis,inbox,more
      integer button
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
c
      call notify('Click on the line or arc you wish to delete. ')
      call getpoint(x,y,button)
      call delete_line(x,y,more)
      if(.not. more) return
      do i = 1, next_arc - 1
         xmin = min(x1(i),x2(i),x3(i)) 
         ymin = min(y1(i),y2(i),y3(i)) 
         xmax = max(x1(i),x2(i),x3(i)) 
         ymax = max(y1(i),y2(i),y3(i)) 
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            idash(i) = 0
            iwid(i) = 1
            arc_dis(i) = .false.
            x1(i) = 0.0
            y1(i) = 0.0
            x2(i) = 0.0
            y2(i) = 0.0
            x3(i) = 0.0
            y3(i) = 0.0
            cx(i) = 0.0
            cy(i) = 0.0
            r(i)  = 0.0
            call delete_arrow(x1(i),y1(i))
            call delete_arrow(x3(i),y3(i))
            call notify('Arc deleted. ')
            return
         endif
      enddo
      return
      end
c
c
      subroutine arc_style(x,y,istyle)
c
      logical arc_dis
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
c
      do i = 1, next_arc - 1
         xmin = min(x1(i),x2(i),x3(i)) 
         ymin = min(y1(i),y2(i),y3(i)) 
         xmax = max(x1(i),x2(i),x3(i)) 
         ymax = max(y1(i),y2(i),y3(i)) 
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            if(istyle .ge. 10) then
               iwid(i) = istyle - 10
               call notify('Arc width changed. ')
            else 
               idash(i) = istyle
               call notify('Arc style changed. ')
            endif
            return
         endif
      enddo
      return
      end
c
c
      subroutine arc_arrow(x,y)
c
      logical arc_dis,inbox,arrow_dis
      common/arcs/arc_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            x3(40),y3(40),cx(40),cy(40),r(40),next_arc,
     &            idash(40),iwid(40)
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
c
      do i = 1, next_arc - 1
         xmin = x1(i) - 0.125
         ymin = y1(i) - 0.125
         xmax = x1(i) + 0.125
         ymax = y1(i) + 0.125
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            call clock_tangent(cx(i),cy(i),x1(i),y1(i),xet,yet)
            call arrow_head(xet,yet,x1(i),y1(i))
            xb(next_head) = xet 
            yb(next_head) = yet 
            xe(next_head) = x1(i)
            ye(next_head) = y1(i)
            arrow_dis(next_head) = .true.
            next_head = next_head + 1
            call notify('Added arrowhead to arc. ')
            return
         else
            xmin = x3(i) - 0.125
            ymin = y3(i) - 0.125
            xmax = x3(i) + 0.125
            ymax = y3(i) + 0.125
            if(inbox(x,y,xmin,ymin,xmax,ymax)) then
               call counter_tangent(cx(i),cy(i),x3(i),y3(i),xet,yet)
               call arrow_head(xet,yet,x3(i),y3(i))
               xb(next_head) = xet
               yb(next_head) = yet
               xe(next_head) = x3(i) 
               ye(next_head) = y3(i) 
               arrow_dis(next_head) = .true.
               next_head = next_head + 1
               call notify('Added arrowhead to arc. ')
               return
            endif
         endif
      enddo
      return
      end
c
c
      subroutine counter_tangent(x1, y1, x2, y2, x, y)
c
      x = x2 + (y2 - y1)
      y = y2 - (x2 - x1)
      return
      end
c
c     
      subroutine clock_tangent(x1,y1,x2,y2,x,y)
c
      x = x2 - (y2 - y1)
      y = y2 + (x2 - x1)
      return
      end
