      subroutine plot (x,y,ipen)
c
c Perform the specified pen motion.
c This routine is currently set up for a SUN running under SUNWindows.
c
C  Where:
C    x,y = coordinates, in inches from the current origin, of the position
C          to which the pen is to be moved
C
C    ipen = pen control, origin definition, and plot termiination such that:
C      if ipen = 1, move with pen in present condition
C      if ipen = 2, move with pen down
C      if ipen = 3, move with pen up
C      if ipen = -1, move with no pen change, reset origin to terminal position
C      if ipen = -2, move with pen down, reset origin to terminal position
C      if ipen = -3, move with pen up, reset origin to terminal position
C      if ipen = 666, see 999.
C      if ipen = 999, move with pen up, terminate plot, close plot file
C      if ipen = anything else, no action is taken
C
c James Blake
c @(#)plot.f	1.1  4/3/89 
c
      integer name,windowfd,retained,dd,cmapsize
      integer flags,noargs,defflag,color
      character*256 screenname,windowname,cmapname,ptr
      real x,y,origx,origy
      logical reset,penup
      include 'device_type.h'
      common /chr/ screenname,windowname,cmapname,ptr
      common /int/ name,windowfd,retained,dd,       
     *   cmapsize,flags,noargs,defflag,color
      common /where2/ ix(2),iy(2)
      common /origin/ origx,origy
      common /tscale/ sfactt
      common /pwhere/ xlast,ylast
      common /cqpbnf/ xold, yold, fac, ires
      logical pen_up
      save    pen_up
      data  pen_up /.true./
c
      data penup / .true. /,reset / .false. /
      data ix / 0,0 /,iy / 0,0 /
c
      if (color_ws .or. mono_ws) then
         xlast = x
         ylast = y
c
c     if imd<0 (reset origin) set reset flag
c
         if (ipen.lt.0) then
            imd = -ipen
            reset = .true.
         else
            imd = ipen
         endif
         if (imd.eq.1) then
            if (penup) then
               imd = 3
            else
               imd = 2
            endif
         endif
c
c     shift for the origin for a 10" x 10" piece of paper.
c
         if (imd.ne.999 .or. imd .ne. 666) then
            ix(2) = screenx(x)
            iy(2) = screeny(y)
         endif
c
c     write the sequence corresponding to the mode
c
         if (imd.eq.999) then
            call getpoint(x,y,i)
            call cfdeactvws (name)
            call cfclosevws (name)
            call cfclosecgi ()
         elseif (imd.eq.666) then
            call cfdeactvws (name)
            call cfclosevws (name)
            call cfclosecgi ()
         elseif (imd.eq.3) then
            penup = .true.
            ix(1) = ix(2)
            iy(1) = iy(2)
         elseif (imd.eq.2) then
            penup = .false.
            call cfpolyline (ix,iy,2)
            ix(1) = ix(2)
            iy(1) = iy(2)
c
c       no check for imd=1 as it was already set to 2 or 3 depending
c       on the current pen state....
c
         else
            return
         endif
c
c     if reset flag then use x,y for the new origin
c
         if (reset) then
            origx = ix(2)
            origy = iy(2)
            reset = .false.
         endif
      elseif (PostScript) then
         locpen = abs (ipen)
C
C   Check pen for proper values
C
         if (locpen .ne. 1 .and. locpen .ne. 2 .and. 
     &       locpen .ne. 3 .and. ipen .ne. 666 .and. 
     &       ipen .ne. 999) return
C
C   Reset locpen to current pen status
C
         if (locpen .eq. 1) then
             if (pen_up) then
                locpen = 3
         else
             locpen = 2
         endif
         elseif (ipen .eq. 666) then
            locpen = 999
         endif
C
C   Set up for move or draw
C     Output "x y"
C
         call pliout (nint (x * fac * ires))
         call plcout (char(32))
         call pliout (nint (y * fac * ires))
C
C   Pen down - draw
C
         if (locpen .eq. 2) then
            call plsout (" D\n")
            pen_up = .false.
C
C   Pen up - move
C
         else if (locpen .eq. 3 .or. locpen .eq. 999) then
            call plsout (" M\n")
            pen_up = .true.
         endif
         if (ipen .ge. 0) then
            xold = x
            yold = y
         else
C
C     Set new origin
C
            call plsout ("O\n")
            xold = 0.0
            yold = 0.0
         endif
C
C   Close and clean up plot file
C
         if (locpen .eq. 999) then
            call plsout ("showpage\n")
            call plsout ("restore\n")
            call plsout ("% End File\n")
            call plcond
            call pldone
         endif
      endif
      return
      end
