/*
 * low-level i/o routines for the PostScript plotting package FORTRAN
 * Callable
 * 
 * Rex Sanders, USGS, 2/87 Jim Blake @(#)pl.c	1.5  4/5/90
 * 
 */

#include <stdio.h>

static FILE    *fp;
static char     fname[80];
static char    *prologue_file = PROLOGUE;

void
plbegn_()
{
    char           *cuserid(), s[40];
    fname[0] = '\0';
    cuserid(s);
    sprintf(fname, "/tmp/ps_plot%s", s);
    if ((fp = fopen(fname, "w")) == NULL) {
	fprintf(stderr, "Couldn't open plotting file, check permissions\n");
	exit(1);
    }
}

void
plcond_()
{
#ifdef CONTROL_D
  putc (4, fp);
  putc ('\n', fp);
#endif
}

void
pldone_()
{
    fclose(fp);
}

void
plogue_()
{
    FILE           *fpin, *fopen();
    char            line[80];

    if ((fpin = fopen(prologue_file, "r")) == NULL) {
	fprintf(stderr, "Can not open prologue file %s\n", prologue_file);
	exit(1);
    }
    while (fgets(line, 80, fpin) != NULL) {
	fprintf(fp, "%s", line);
    }
}

void
plcout_(c)
    char           *c;
{
    /*
     * send one char to plot file
     */
    putc(*c, fp);
}

void
pliout_(i)
    int            *i;
{
    /*
     * send one integer value to plot file
     */
    fprintf(fp, "%d", *i);
}

void
plfout_(f)
    float          *f;
{
    /*
     * send one float value to plot file
     */
    fprintf(fp, "%.3f", *f);
}
void
plsout_(s, l)
    char           *s;
    long int        l;
{
    /*
     * send a string to plot file
     */
    char           *string;
    for (string = s; l > 0; l--, string++)
	putc(*string, fp);
}

void
print_it_()
{
    char            plot_cmd[256];
    /*
     * send a string to my shell
     */
    plot_cmd[0] = '\0';
    sprintf(plot_cmd, "lpr -r %s\n", fname);
    system(plot_cmd);
}

void
move_it_(char_ptr, true_len, n_ptr)
    char            char_ptr[];
int            *n_ptr, *true_len;
{
    char            plot_cmd[256];
    /*
     * send a string to my shell
     */
    char_ptr[*true_len] = '\0';

    plot_cmd[0] = '\0';
    sprintf(plot_cmd, "/bin/mv %s %s\n", fname, char_ptr);
    system(plot_cmd);
}

void
stereo_view_()
{
    char            plot_cmd[256];
    /*
     * send the command to generate VIEWing size plots.
     */
    plot_cmd[0] = '\0';
    sprintf(plot_cmd,
    "mugs -x 4 -y 3 -r -s blank blank blank blank blank left right | lpr\n");
    system(plot_cmd);
}

void
stereo_pub_()
{
    char            plot_cmd[256];
    /*
     * send the command to generate PUBlication size plots.
     */
    plot_cmd[0] = '\0';
    sprintf(plot_cmd, "mugs -x 2 -y 1 -r -s left right | lpr\n");
    system(plot_cmd);
}

void
units()
{
}
