      subroutine oncenter(x1,y1,height,str,theta,nchar)
c
c  Output an oncenter symbol 
c  Fonts re-encoded by Jim Briggs Nov 88.
c @(#)oncenter.f	1.1  4/3/89 
c
      character*1 str(1024)
      integer*2 ifont(164)
      dimension kct(28),koc(28)
      data ifont /
     1  O'00',O'04',O'44',O'40',O'00',
     1  O'03',O'01',O'10',O'30',O'41',O'43',O'34',O'14',O'03',
     1  O'00',O'40',O'24',O'00',
     1  O'24',O'20',O'22',O'42',O'02',
     1  O'04',O'40',O'22',O'44',O'00',
     1  O'02',O'20',O'42',O'24',O'02',
     1  O'20',O'22',O'02',O'24',O'42',O'22',
     1  O'00',O'44',O'04',O'40',
     1  O'04',O'44',O'00',O'40',
     1  O'04',O'22',O'20',O'22',O'44',
     1  O'04',O'13',O'11',O'00',O'11',O'31',O'40',O'31',
     2  O'33',O'44',O'33',O'13',
     1  O'22',O'04',O'40',O'22',O'44',O'00',O'22',O'24',
     2  O'20',O'22',O'02',O'42',O'22',
     1  O'22',O'04',O'44',O'00',O'40',O'22',
     1  O'24',O'20',
     1  O'40',O'03',O'43',O'00',O'24',O'40',
     1  O'02',O'42',
     1  O'42',O'12',O'13',O'02',O'11',O'12',
     1  O'24',O'21',O'11',O'20',O'31',O'21',
     1  O'20',O'23',O'13',O'24',O'33',O'23',
     1  O'00',O'40',O'70',O'02',O'42',O'70',O'04',O'44',
     1  O'02',O'32',O'33',O'42',O'31',O'32',
     1  O'03',O'13',O'14',O'04',O'03',O'70',O'00',O'44',
     2  O'70',O'40',O'41',O'31',O'30',O'40',
     1  O'02',O'44',O'06',O'70',O'01',O'41',
     1  O'00',O'24',O'40',
     1  O'01',O'41',O'70',O'03',O'43',O'70',O'34',O'10',
     1  O'11',O'31',O'70',O'22',O'24',O'23',O'33',O'13'/
c
c   Total bytes = 164
c
      data kct/
     1  05,09,04,05,05,05,06,04,04,05,12,13,06,02,06,02,
     1  06,06,06,08,06,14,06,03,08,08,00,00/
      data koc/
     1  1,6,15,19,24,29,34,40,44,48,53,65,78,84,86,92,94,
     1  100,106,112,120,126,140,146,149,157,165,000/
c
c
      h=height
      nc=nchar
      if(ichar(str(1)) .eq. 27) then
         call polycolor(8)
         call circle(x1,y1,0.025)
         return
      elseif(ichar(str(1)) .eq. 28) then
         call polycolor(1)
         call circle(x1,y1,0.025)
         return
      endif
      if(nc.eq.0) return 
      si=sind(theta)
      co=cosd(theta)
      x=x1
      y=y1
      if(nc.ge.1) go to 50
30    fact=h/4.0
      x=x-2.0*fact*(co-si)
      y=y-2.0*fact*(co+si)
      nc=1
      if(nchar.ge.-1) go to 60
40    ic=2
      go to 70
50    fact=h/7
60    ic=3
70    xa=fact*co
      ya=fact*si
      xt=xa*6.0
      yt=ya*6.0
      idel=1
      j=1
      if(nc.le.2) go to 100
80    stlen=float(nc-1)
      xn=x+xt*stlen
      yn=y+yt*stlen
      call  where(xnow,ynow,g)
      del1=max1(abs(x-xnow),abs(y-ynow))
      del2=max1(abs(xn-xnow),abs(yn-ynow))
      if(del1.lt.del2) go to 100
90    j=nc
      idel=-1
      xk=xn+xt
      yk=yn+yt
      x=xn
      y=yn
      xt=-xT
      yt=-yt
100   do 210 ii=1,nc
c
c    Plot oncenter symbols.
c
         itsub=ichar(str(j))
         itsub=itsub+1
         j=j+idel
         ict=kct(itsub)
         if(ict.eq.00) go to 200
         loc=koc(itsub)
         do 115 i=1,ict
            iy=ifont(loc+i-1)
            xx=and(iy/8,O'7')
            if(xx.eq.7) goto 110
            yy=and(iy,O'7')
            xn=x+xa*xx-ya*yy
            yn=y+ya*xx+xa*yy
            call plot(xn,yn,ic)
            ic=2
            go to 115
110         ic=3
115      continue
200      x=x+xt
         y=y+yt
         ic=3
210   continue
      return
      end
