\" @(#)graphics.l 1.7 88/11/03 ;
.TH graphics 1L "10 December 1988" "Local" "LOCAL COMMANDS"
.SH SYNOPSIS
.LP
These basic routines allow users to plot graphics on any of the Sun 4's and the
LaserWriter.  Below is a Makefile that shows how one links to
libgraphics.a for SunView or for the LaserWriter.
.nf    
# 
# Makefile for programs located in /usr2/people/jim 
# 
FFLAGS = -w -O 
LDFLAGS = -s -o 
GRLIBS = -lgraphics -lcgi77 -lcgi -lsunwindow -lpixrect

spline : spline.o spllib.o
        f77 ${FFLAGS} spline.o spllib.o ${GRLIBS} ${LDFLAGS} spline

.fi    
.TP 7 
Note:
If the device is PostScript (see subroutine \fBPLOTS\fP), the ouput is directed
to a file (/tmp/ps_plot<username>) that may be plotted on the LaserWriter 
with the command
``lpr /tmp/ps_plot<username>''.

.TP 12
Subroutine:    
\fBAXIS\fP
.TP
Purpose:       
Pen manipulation - displays a plotting axis.
.TP
Sequence:
CALL AXIS(X,Y,STRING,NS,SIZE,ANGLE,XMIN,DX,LROT,IFORM)
.TP
Parameter(s):
.TP
X, Y        
The coordinates (in inches) of the starting point of the axis.
.TP
STRING         
A Character string or the identifier of a variable or array containing a
character string of length  NS characters, which is to be used as the axis
label.
.TP
NS             
In magnitude, the number of characters to be plotted from STRING; in addition,
if NS > 0 the label will be plotted on the counterclockwise side of the axis,
and if NS < 0 the label will be plotted on the clockwise side.
.TP
SIZE           
The length (in inches) of the coordinate axis.
.TP
ANGLE          
The angle (in degrees) counterclockwise from the positive
X-direction at which the coordinate axis is to be drawn.
.TP
XMIN           
The numerical value corresponding to the first tic-mark of the axis (at the
point (X,Y)), usually the same as the adjusted minimum computed by subroutine
\fBSCALE\fP or the programmer for use by subroutine \fBLINE\fP.
.TP
DX             
The scale increment per inch along the axis, usually the same as the adjusted
increment computed by subroutine SCALE or the programmer for use by subroutine
LINE.
.TP
LROT           
A parameter used to select the style of the numeric (tick mark) annotation
plotted with the axis; if LROT is negative (magnitude is not important), the
tick marks will appear on the negative side of the coordinate axis (usual
case).  Positive values produce the opposite, inward effect.
.TP
IFORM          
Variable to control format of axis numbers, see subroutine \fBNUMBER\fP for the
correspondences.


.TP
Subroutine:    
\fBCENTER\fP
.TP
Purpose:       
Center a proportionally spaced string.
.TP
Sequence:
CALL CENTER(X,Y,H,STRING,ANGLE)
.TP
Parameter(s):
.TP
X, Y        
Coordinates (in inches) of the point you wish to center the text around.
.TP
H              
Height of the text string (in inches).
.TP
STRING
A character*(*) text string to be centered.
.TP
ANGLE
The angle at which the text string is to be plotted.
.TP
Remarks:
This routine is used in subroutine \fBAXIS\fP to align the numbers on the
abscissa axis. See also routine \fBRIGHT_JUSTIFY\fP. 
.TP
Subroutine:    
\fBCIRCLE\fP
.TP
Purpose:       
Draw a filled circle.
.TP
Sequence:
CALL CIRCLE(X,Y,R)
.TP
Parameter(s):
.TP
X, Y        
Coordinates (in inches) of the center of the circle.
.TP
R              
Radius of the circle (in inches).
.TP
Remarks:
Circle will draw a filled circle using the current fill color as defined by
subroutine \fBPOLYCOLOR\fP.



.TP
Subroutine:    
\fBDSHLIN\fP
.TP
Purpose:       
Plots data points using dashed lines.
.TP
Sequence:
CALL DSHLIN(XA,YA,N,DSH,GAP,NSEC)
.TP
Parameter(s):
.TP
XA,YA,N      
Equivalent to \fBLINE\fP with K=1.
.TP
DSH            
An array of length NSEC containing the lengths of the
sequence of dashes to be used in plotting the relationship.
.TP
GAP            
An array of length NSEC containing the lengths of the
sequence of spaces between dashes to be used in plotting the
relationship.
.TP
NSEC           
The number of dashes and gaps in the dash-gap sequence.
.TP
Remarks:
Arbitrarily complex dash-gap sequences may be specified.  \fBDSHLINE\fP first
plots a dash of length DSH(1), then a gap of length GAP(1), then a dash of
length DSH(2), etc.  After plotting GAP(NSEC), the sequence is repeated
starting again with DSH(1).  If NSEC = 0, DSH and GAP are ignored and the curve
is plotted as a solid-line curve by subroutine LINE.  If NSEC = 1, DSH and GAP
may be simple variables, constants, or expressions.  Arrays XA and YA must be
dimensioned at least N+2, and the adjusted minimum and increment per inch of
each array must be stored in the N+1st and N+2nd array positions, respectively,
as with subroutine \fBLINE\fP.  Note that there is no argument corresponding to
the argument K of subroutine \fBLINE\fP.

.TP
Subroutine:    
\fBFACTOR\fP
.TP
Purpose:       
Sets the global scaling factor.
.TP
Sequence:
CALL FACTOR(SF)
.TP
Parameter(s):
.TP
SF             
The new scale factor to be used in scaling all subsequent X
and Y coordinates unless and until subroutine \fBFACTOR\fP is
called again.
.TP
Remarks:
If a scale factor SF has been specified then the coordinates
(X,Y) are scaled to the point (SF*X,SF*Y).  Therefore using a
scaling factor with a value greater than one (1.0) will increase
the size of your plots.
.TP
Subroutine:    
\fBFIGURE\fP
.TP
Purpose:       
Eject current page and continue plotting.
.TP
Sequence:
CALL FIGURE
.TP
Remarks:
This subroutine allows the user to retain the picture on the
screen.  A call to figure will enable an input from the
mouse; pressing any button causes the program to continue.
\fBFIGURE\fP ejects the current page and begins a new page, saving
the current graphics state, thus enabling multiple pages on
the LaserWriter.



.TP
Subroutine:    
\fBGETPOINT\fP
.TP
Purpose:       
Enable the mouse for one input event and return the current
position of the printer's fist.
.TP
Sequence:
CALL GETPOINT(X,Y,IBUT)
.TP
Parameter(s):
.TP
X and Y        
Coordinates of the point selected (in inches) relative to
the current origin.
.TP
IBUT           
Number of the button pressed:  
.RS
.TP
1 - 
Left 
.TP
2 - 
Middle 
.TP
3 - 
Right
.RE



.TP
Subroutine:    
\fBHIDE\fP
.TP
Purpose:       
Generate a 2-dimensional representation of a 3-dimensional
figure or surface.
.TP
Sequence:
CALL HIDE(X,Y,XG,G,XH,H,NG,MAXDIM,N1,NFNS,TITLE,XLNTH,YLNTH,XMIN,DELTAX,YMIN,DELTAY,IFORM)
.TP
Parameter(s):
.TP
X              
An array dimensioned at least N1, containing the N1 abscissa
values for a single line.  The X array values need not be in
inches as they are scaled by XMIN and DELTAX before plotting,
however the X array must be stored in increasing order.
.TP
Y              
In array dimensioned at least N1, containing the N1 ordinate
values for a single line.  The Y array is scaled by YMIN and
DELTAY before plotting.
.TP
XG, G       
Two arrays dimensioned at least MAXDIM which will be used by
\fBHIDE\fP to store the visual maximum (or minimum) function
between calls to \fBHIDE\fP.  If the visual minimum and maximum are
being plotted simultaneously separate arrays must be used.
.TP
XH, H       
Two arrays dimensioned at least MAXDIM which are used as
temporary storage by \fBHIDE\fP.  Separate arrays need not be used
when plotting the visual maximum and minimum simultaneously.
.TP
NG             
An integer variable (must not be a literal) which for the
first call may take the following values:  
.RS
.TP 5
0:       
Normal
.TP
-1:       
Suppress 8-l/2 x 11 inch border.  
.TP
-2:       
Plot unhidden minimum rather than maximum.  
.TP
-3:       
Do not plot border, plot minimum rather than maximum.
.RE
\fBHIDE\fP will return in NG the number of points in the current
visual maximum (minimum).  This value must be passed back to
\fBHIDE\fP on subsequent calls.  When plotting minimum and maximum
simultaneously, two separate variables must be used.
.TP
MAXDIM         
An integer variable (must not be a literal) specifying the
number of locations available in the XG, G, XH and H arrays.
As an initial guess, MAXDIM should be made 3 to 5 times as
large as N1.  When errors are detected by \fBHIDE\fP, MAXDIM is set
zero or negative.  Further calls to \fBHIDE\fP will be ignored
unless MAXDIM is reset.
.TP
N1             
An integer variable (must not be a literal) specifying the
number of points in the current X vs. Y curve.  If N1 is
negative the visual maximum function will be updated but no
plotting will take place.  N1 is always returned as N1.
.TP
NFNS           
The total number of curves to be plotted in the depth
dimension.  This number is used in computing the origin
displacement required to simulate the depth dimension. IF
NFNS is negative no translation will be made, if NFNS is zero
the curve will be translated the same as the previous call to
\fBHIDE\fP.
.TP
TITLE          
A character sting containing a title for the plot.  If the
first word of this array is 'nottle' no title will be
plotted.
.TP
XLNTH          
The length (in inches) of the horizontal X-axis.  XLNTH
should be within the range 1.0 < XLNTH <8.0.  If XLNTH is
negative the axis will not be labeled.
.TP
YLNTH          
The length (in inches) of the vertical Y-axis.  YLNTH should
be within the range 1.0 < YLNTH < 6.0.  If YLNTH is negative
the Y-axis will not be labeled.
.TP
XMIN           
A lower bound for the X array.
.TP
DELTAX         
The increment per inch for the X array.  Each element of the
X array is scaled as (X(I)-XMIN)/DELTAX. YMIN The origin
value for the Y array, normally a lower bound.
.TP
DELTAY         
The increment per inch for the Y array.  Each element of the
Y array is scaled as (Y(I)-YMIN)/DELTAY.
.TP
IFORM          
See subroutine \fBNUMBER\fP for information on IFORM.
.TP
Remarks:
The following guidelines should be used in selecting initial
values for variable.
.nf
Type of Line             NG   N1   NFNS  XLNTH  YLNTH

Top view of surface      0    >0    >0    >0     >0

Top view, no border      -1   >0    >0    >0     >0

Bottom view of surface*  -3   <0    =0    <0     <0

Top view, no labeling    -1   >0    >0    <0     <0

*When plotting top and bottom simultaneously
.fi
.TP
Additional Remarks:
Subroutine \fBHIDE\fP is called once for each line to be plotted.  The first
line is plotted in its entirety.  Only that portion of subsequent lines that is
visually above (optionally below) all previous lines will be plotted.
\fBHIDE\fP normally moves the origin for each subsequent line up and to the
left a small amount.  The result is an orthographic projection with hidden
lines eliminated.  \fBHIDE\fP is called with l8 arguments as described above.
Many of the arguments represent different things for other than the first
call.  Several arguments use the sign of its value (plus or minus) to represent
something and the absolute value of the argument to represent something else.




.TP
Subroutine:    
\fBLINE\fP
.TP
Purpose:       
Plots a series of data points.
.TP
Sequence:
CALL LINE(XA,YA,N,K,J,L)
.TP
Parameter(s):
.TP
XA, YA      
Arrays containing the X and Y coordinates of a parametric
relationship (Xi,Yi) (as for \fBSCALE\fP) and scaling information
either provided directly by the user's program or use of
\fBSCALE\fP (see Remarks below).
.TP
N              
The number of data points (Xi,Yi) in the parametric
relationship (as for \fBSCALE\fP).
.TP
K              
Normally 1, it specified that the N points (Xi,Yi) are
stored in the 1st, K+1st, 2*K+1st, ..., (N-1)*K+1st positions
of the arrays XA and YA (again, as for \fBSCALE\fP).
.TP
J
Determines how the symbols are to be connected with:
.RS
.TP 5
> O:      
Plot a straight line segment between each
consecutive pair of points, and the on-center symbol
specified by L at every Jth point.  
.TP
= 0:      
Plot a straight line segment connecting each consecutive pair of points, but
no on-center symbols.  
.TP
< 0:      
Plot the on-center symbol specified by L at every  Jth point, but no
interconnecting line.
.RE
.TP
L              
Between 0 and 28, an integer which specifies the on-center
symbol (See subroutine \fBSYMBOL\fP).
.TP
Remarks:
If J > 0, use L between 0 and 13 for best results.


.TP
Subroutine:    
\fBLINE_WIDTH\fP
.TP
Purpose:       
Change the width of lines.
.TP
Sequence:
CALL LINE_WIDTH(I)
.TP
Parameter(s):
.TP
I
The width of the line in pixels.

.TP
Subroutine:    
\fBNEWPEN\fP
.TP
Purpose:       
Select pen for future drawing operations.
.TP
Sequence:
CALL NEWPEN(N)
.TP
Parameter(s):
.TP
N              
The number of the new pen, 1 through 8, to be used for
subsequent drawing operations.
.TP
Remarks:
Initially, pen 1 is selected.  \fBNEWPEN\fP changes the color of
the line:
.RS
.TP
1: 
black 
.TP
2:         
red 
.TP
3:         
yellow 
.TP
4:
green 
.TP
5:         
cyan 
.TP
6:         
blue 
.TP
7:         
magenta
.TP
8:         
white
.RE
\fBNEWPEN\fP changes the width of the line drawn on the LaserWriter.  The
routine also effects the text and perimeter color.

.TP
Subroutine:    
\fBNUMBER\fP
.TP
Purpose:       
Pen manipulation - displays numeric values.
.TP
Sequence:
CALL NUMBER(X,Y,HEIGHT,NUM,ANGLE,FORMAT)
.TP
Parameter(s):
.TP
X and Y        
The coordinates (in inches) of the point where the lower
left corner of the first character of the character string
resulting from the encoding of NUM according to parameter
FORMAT is to be plotted.
.TP
HEIGHT         
The height (in inches) of the characters with which NUM is
to be plotted.
.TP
NUM            
A constant, variable identifier, or expression, whose value
is to be plotted.  Its type (real, integer, etc.) must be
compatible with the conversion implied by FORMAT.
.TP
ANGLE          
The angle (in degrees) counterclockwise from the positive
X-direction at which the conversion is to be plotted.
.TP
FORMAT         
An integer descriptor that determines the format of the
number to be plotted.  Valid values are:
.nf
1 = f6.4    2 = f6.3    3 = f6.2    4 = f6.1    5 = f6.0
6 = f5.3    7 = f5.2    8 = f5.1    9 = f5.0    10= f4.2
11= f4.1    12= f3.1    13= I6      14= I5      15= I4
16= I3      17= I2      18= I1
.fi
.TP
Remarks:
For legibility, HEIGHT should be at least 0.07 inch.

.TP
Function:      
\fBPAGE_X\fP and \fBPAGE_Y\fP
.TP
Purpose:       
Return the location on the screen from the current origin.
.TP
Sequence:
XPOS = PAGE_X(IX)
.TP
Parameter(s):
.TP
IX      
Integer descriptors whose values are the X or Y coordinates
(in VDC units) of the point.
.TP
XPOS 
Position on the screen (in inches) relative to the origin.
.TP
Remarks:
These routines are mainly for internal graphics support.
See also functions \fBSCREENX\fP and \fBSCREENY\fP.



.TP
Subroutine:    
\fBPLOT\fP
Purpose:       
Pen movement.  Current origin positioning.  Plot file completion.
.TP
Sequence:
CALL PLOT (X,Y,IPEN)
.TP
Parameter(s):
.TP
X, Y        
The coordinates (in inches) of the point to which the pen is
to be moved, relative to the current origin.  The pen is
moved from its current position to X,Y along a straight line.
Must be real values.
.TP
IPEN           

.RS
.TP 5
1:        
Move the pen without changing its vertical position.  
.TP
2:        
Put the pen down (on the paper) before moving to (X,Y).  
.TP
3:        
Raise the pen before moving to (X,Y).  
.TP
666:      
Terminate the plot and do not preserve the image.  
.TP
999:      
Successfully terminate the current plot and
complete the plot file, will also keep the image on the
screen.
.RE
.TP
Remarks:
Pen motion is executed for all legal values of (I) except 666 and 999.
Positive values of (I) indicate that the pen is to moved only.  Negative values
of (I) cause the point (X,Y) to become the current plotting origin after the
pen has been moved.  Unless and until the origin is again redefined, all future
coordinates will specify positions with respect to this point.  Often, I = -3
is used when moving from one graph within a figure to another.  For example,
suppose a graph has been completed about an origin near the bottom of the
figure with a Y (vertical) axis length of 4.0 inches.  To place a similarly
dimensioned graph above the first, the statement CALL PLOT (0.0,5.5,-3) will
move the origin to a point 5.5 inches above the origin of the first graph to
allow for the second graph to be drawn.  If (I) is 999, the values of X and Y
are disregarded and a printer's fist appears to retain the image, clicking the
mouse button terminates the plot.  The plot file (/tmp/ps_plot<username>) 
is closed following the so-called ``successful'' completion of the 
current figure.

.TP
Subroutine:    
\fBPLOTS\fP
.TP
Purpose:       
Plot file initialization and/or figure initialization.
.TP
Sequence:
CALL PLOTS (I,DEVICE)
.TP
Parameter(s):
.TP
I 
.RS
.TP
0: 
Complete initialization of plotting, should only be called
once per program.
.TP
1: 
Partial initialization,  will erase the page and reset
variables to default values.
.RE
.TP
DEVICE:        
.RS
.TP
1:
The SunView environment is expected.  You must be running in SunView.
.TP
2:
The PostScript option is chosen and plotting commands are written to the
``/tmp/ps_plot<username>'' file.
.RE
.TP
Remarks:
\fBPLOTS\fP performs preset tasks for the plotting subroutines and
must be called previous to any use of routines which cause
pen manipulation.  The most important of these tasks is plot
file initialization.



.TP
Subroutine:    
\fBPOLYCOLOR\fP
.TP
Purpose:       
Change the color of subsequent filled polygons.
.TP
Sequence:
CALL POLYCOLOR(I)
.TP
Parameter(s):
.TP
I              
An integer descriptor (between 1 and 8) specifying the color
of the filled polygon.  See subroutine \fBNEWPEN\fP for the
corresponding colors.
.TP
Remarks:
On the LaserWriter, \fBPOLYCOLOR\fP will change the ``color'' by outputting
various shades of gray ranging from 1 corresponding to  black and 8 to white.

.TP
Subroutine:    
\fBPOLYGON\fP
.TP
Purpose:       
Draw a filled polygon using the current fill color.
.TP
Sequence:
CALL POLYGON(VX,VY,NVERT)
.TP
Parameter(s):
.TP
VX, VY     
Coordinates (in inches) of a vertex of the polygon.
.TP
NVERT          
The total number of vertices in the polygon.
.TP
Remarks:
A total of 100 vertices may be used to specify a polygon, at least three
points must be specified.  The polygon is drawn, filled with the currently
defined fill color.

.TP
Subroutine:    
\fBRIGHT_JUSTIFY\fP
.TP
Purpose:       
Right justify a proportionally spaced string.
.TP
Sequence:
CALL RIGHT_JUSTIFY(X,Y,H,STRING)
.TP
Parameter(s):
.TP
X, Y        
Coordinates (in inches) of the point you wish to right justify the text at.
.TP
H              
Height of the text string (in inches).
.TP
STRING
A character*(*) text string to be right justified.
.TP
Remarks:
This routine is used in subroutine \fBAXIS\fP to align the numbers on the
ordinate axis. See also routine \fBCENTER\fP. 

.TP
Subroutine:    
\fBSCALE\fP
.TP
Purpose:       
Determines pleasing scaling parameters.
.TP
Sequence:
CALL SCALE(XA,XL,N,K)
.TP
Parameter(s):
.TP
XA      
Array containing the X coordinates of a parametric
relationship (Xi,Yi).
.TP
XL     
The length (in inches) of the X axis.
The length must be at least one inch if the corresponding
data is all of the same sign and two inches if the data
crosses zero.
.TP
N              
The number of data points (Xi,Yi) in the parametric
relationship.  N must be less than the dimension of XA.
.TP
K              
Normally 1, it specifies that the N points (Xi,Yi) are
stored in the 1st, K+1st, 2*K+1st,...,(N-1)*K+1st positions
of the array XA (every Kth element pair in XA is taken as a data point).
.TP
Remarks:
The array XA must be dimensioned at least (N+1)*K+1.  In other words,
set the array capacities to be large enough to allow for storage of two
additional data items.  The lst, K+1st, 2*K+1st,..., (N-1)*K+1st positions of
the arrays are scanned for the maximum and minimum elements.  An adjusted
minimum and an adjusted increment per inch are then computed and stored in the
N*K+1st and (N+1)*K+1st array positions, respectively (see Remarks for
subroutine \fBLINE\fP).  The adjusted minimum and increment per inch are
normally passed to \fBAXIS\fP (XMIN and DX) in order to provide a plotting axis
which corresponds to the data plotted by \fBLINE\fP.  \fBSCALE\fP attempts to
center the plot along the axes. Therefore, occasionally when the data is all
positive, the adjusted minimum may be negative.  This routine would be called 
for the corresponding Y array.


.TP
Function:      
\fBSCREENX\fP and \fBSCREENY\fP
.TP
Purpose:       
Determine the X or Y coordinate on the screen in VDC coordinate system.
.TP
Sequence:
ICX = SCREENX(X) 
.TP
Parameter(s):
.TP
X, Y        
Coordinates (in inches) of the point.
.TP
ICX, ICY    
Position of the point (in VDC units).
.TP
Remarks:
This is mainly an internal use function for graphics support.  This routine may
be used in conjunction with \fBGETPOINT\fP to pick points and then display
objects at those points.



.TP
Subroutine:    
\fBSETDASH\fP
.TP
Purpose:       
Control toggle of dashed line style.
.TP
Sequence:
CALL SETDASH(I)
.TP
Parameter(s):
.TP
I              
Integer descriptor with:
.RS
.TP
0: 
Specifies a default solid line.  
.TP
1: 
Specifies that a generic dashed line is turned on.
.RE
.TP
Remarks:
Perimeters of polygons and circles are also affected.



.TP
Subroutine:    
\fBSYMBOL\fP
.TP
Purpose:       
Plotting of character text and on-center plotting symbols.
.TP
Sequence:
CALL SYMBOL(X,Y,HEIGHT,STRING,ANGLE,NS)
.TP
Parameter(s):
.TP
X, Y        
The coordinates (in inches) of the point where:  The lower left corner of the
first character is to be plotted if NS > 0 or the center of the special
on-center symbol is to be plotted if NS < 0.
.TP
HEIGHT 
The height (in inches) of the alphanumeric character string or the
on-center symbol.
.TP
STRING
A character string, or the identifier of a variable or array containing a
character string, of length NS characters if NS > 0.
or an integer constant, variable identifier, or expression, between 0 and 28,
specifying the desired on-center symbol.  Superscripts and subscripts may be
obtained by using the ^ and _ operators, respectively.  Note that these 
operators work on the next character (no space).  The angstrom symbol is
indicated by a \\A (case sensitive). 

.TP
ANGLE 
The angle (in degrees) counterclockwise from the positive X-direction at
which the character string or on-center symbol is to be plotted.
.TP
NS 
An integer constant, variable identifier, or expression which specifies ...
.RS
.TP 5
0:  
The number of characters to be plotted from STRING,
.TP
-1:  
That the pen is to be raised before moving to the position of the
on-center symbol specified by STRING, or
.TP
-2:  
That the pen is to be lowered before moving to the position of the
on-center symbol specified by STRING.
.RE
.TP
Remarks:  
\fBSYMBOL\fP currently uses the Roman-Times font.


.TP
Subroutine:    
\fBWHERE\fP
.TP
Purpose:       
Returns current X,Y coordinates and scale factor.
.TP
Sequence:
CALL WHERE(X,Y,SF)
.TP
Parameter(s):
.TP
X, Y        
Variables for the return of the current pen coordinates (in inches) relative to
the current origin.  Here, current pen coordinates refers to the last X,Y
position at which the pen was down.
.TP
SF 
Variable for the return of the current scale factor.
.TP
Remarks:  
Subroutine \fBWHERE\fP can be used, for example, to determine which
direction the line between the points (X1,Y1) and (X2,Y2) should be drawn in
order to reduce pen movement when the pen position is unknown.  It is primarily
provided for pen motion optimization purposes.  It is also sometimes prudent,
when writing subroutines that perform plotting functions, to save the current
pen position at entry time and restore the position upon return (usually with
the pen up).  This convention allows the calling routine to assume, to a
degree, that the subroutine has performed its services without altering the
state of the caller's plotting situation.  A similar convention is more
strongly recommended for subroutines which alter the global scale factor.
Finally, note that \fBWHERE\fP does not return the current pen up/down position
or number of the pen selected.
.SH FILES
.LP
/usr/local/lib/libgraphics.a
.SH AUTHOR
James Blake
.br
Department of Chemistry
.br
Yale University
.br
New Haven, CT  06511
.br
and unknown others...
