/*
 *  displaytype  --  identify type of display connected to Sun workstation
 *  Returns an integer specifying the depth of the frame buffer.
 *  @(#)fb.c	1.1  4/3/89 
 */

#include <stdio.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sun/fbio.h>

extern int      errno;

char           *displaytype[] =
{
    "Sun 1 monochrome",
    "Sun 1 color",
    "Sun 2 or 3 monochrome",
    "Sun 2 or 3 color",
    "Sun 2 or 3 graphics processor",
    "type unknown",
    "type unknown",
    "Sun 4 monochrome",
    "Sun 4 color",
    ""
};

fb_()
{
    int             fd;
    struct fbtype   fbinfo;	/* struct for frame buffer info */

    fd = open("/dev/fb", O_RDONLY);
    if (fd < 0)
    {
	printf("Error opening /dev/fb, error #%d\n", errno);
	exit(2);
    }
    if (ioctl(fd, FBIOGTYPE, &fbinfo) == -1)
    {
	printf("Ioctl error on /dev/fb, error #%d\n", errno);
	exit(3);
    }
/*  printf("%s  %d x %d x %d pixels\n",
	   displaytype[fbinfo.fb_type],
	   fbinfo.fb_height, fbinfo.fb_width, fbinfo.fb_depth);
*/
    return *((int*)&fbinfo.fb_depth);
}
