c----------------------------------------------------------------------
      subroutine freeread(line, nint, nrea, ncha, inva, rea, cha, form)
c----------------------------------------------------------------------
c 
c          This subroutine does take an input line, separates it into
c     integers, reals, and characters as guided by blanks, and load it
c     into the corresponding arrays.
c
c     INPUT :  LINE (a string up to 80 characters long)
c     OUTPUT : NINT (the number of integers found)
c              NREA (the number of reals found)
c              NCHA (the number of character strings found)
c              INVA (a *-Element array containing all the integers)
c              REA (a *-Element array containing all the reals)
c              CHA (a *-Element array containing the strings)
c
c          The LINE and FORM strings are variable length, so they must be
c     declared in the calling section.  The PLACE and FMTSTR arrays are
c     dimensioned to 160 and 80 elements respectively, so they do 
c     effectively limit the process to 80 substrings per line.  These are
c     unlikely to be exceeded, but in case of this happening this is the
c     only section where numerical dimensioning occurs.  Substituting the
c     values for larger ones in this section would suffice to expand the
c     capabilities.  The INVA, REA, and CHA arrays are dimensioned to 2,
c     which allows act as variable-dimensioned arrays.  The desired
c     dimensionality of these arrays must be also declared in the calling
c     section.  A typical EXAMPLE of the declarations needed in the 
c     MAIN or calling subroutine would be :
c
c      REAL REA
c      INTEGER NINT,NREA,NCHA,INVA
c      CHARACTER*80 LINE,FORM
c      CHARACTER*10 CHA
c
c      DIMENSION INVA(40),REA(40),CHA(40)
c
c                Julian Tirado-Rives, P. U. January 10, 1986
c  
      real rea
      integer place, nstring, i, is, ie, inva, iint, irea, 
     &                 icha, nint, nrea, ncha
      character line*(*), form*(*), cha*(*)
c
      character fmtstr*10
      dimension place(160), fmtstr(80)
c
      dimension inva(2), rea(2), cha(2)
      i = 1
      do while (i .le. len(form))
         form(i:i) = ' '
         i = i + 1
      end do
      call lineanal(line, place, fmtstr, form, nstring)
      i = 1
      iint = 1
      irea = 1
      icha = 1
      do while (i .le. nstring)
         is = place((2 * i) - 1)
         ie = place(2 * i)
         if (form(i:i) .eq. 'I') then
            read(line(is:ie), fmt=fmtstr(i)) inva(iint)
            iint = iint + 1
         end if
c
         if (form(i:i) .eq. 'F') then
            read(line(is:ie), fmt=fmtstr(i)) rea(irea)
            irea = irea + 1
         end if
c
         if (form(i:i) .eq. 'A') then
            read(line(is:ie), fmt=fmtstr(i)) cha(icha)
            icha = icha + 1
         end if
c
         i = i + 1
      end do
      nint = iint - 1
      nrea = irea - 1
      ncha = icha - 1
      return 
      end
