*     ***********************
      SUBROUTINE UPDATE(SKEW)
*     ***********************
*
*     This subroutine prints all relevant data after each cycle.
*
      CHARACTER ATEXT*4,TEXT*80
      REAL SIGMA(8),SMOM(3),SY(14),SZ(6,30)
      INCLUDE 'COMMONS.FOR'
      COMMON/CHARS/ATEXT(30),TEXT
      COMMON/IO/EPS,RELAX,RELAXB,RELAXC,SUMOBS,SUMW,SUMWBS,SW,IPONS,
     *          LMAT,LOUT,NUM
      COMMON/PARAMS/AINSTR(10),ACRYST(22), ATOM(14,30),
     *              LINSTR(10),LCRYST(22),LATOM(14,30),
     *              PINSTR(10),PCRYST(22),PATOM(14,30)
      COMMON/SPACE/JUMP,A,B,C,COSALF,COSBET,COSGAM,SINALF,SINBET,SINGAM
      SAVE
      DATA OLD/0.0/
*
*     MATRIX solves the least squares equation, if it exists.
*
      IF(MAXS.NE.0) CALL MATRIX(SKEW)
      WRITE(6,1003)
*
*     Update atom coordinates and temperature factors.
*
      DO 20 I=1,N
      DO 10 J=1,4
      FACTOR=RELAXB
      IF(J.LT.4) FACTOR=RELAXC
      SY(J)=STEP(FACTOR,ATOM(J,I),LATOM(J,I),Z)
      PATOM(J,I)=PATOM(J,I)+SY(J)
   10 SIGMA(J)=Z
   20 WRITE(6,1004) ATEXT(I),(PATOM(J,I),SY(J),SIGMA(J),J=1,4)
      WRITE(6,1005)
*
*     Update rest of the atom parameters.
*
      DO 40 I=1,N
      DO 30 J=9,14
      SY(J)=STEP(RELAXB,ATOM(J,I),LATOM(J,I),Z)
      PATOM(J,I)=PATOM(J,I)+SY(J)
   30 SZ(J-8,I)=Z
   40 WRITE(6,1006) ATEXT(I),(PATOM(J,I),SY(J),SZ(J-8,I),J=9,14)
      WRITE(6,1007)
      DO 90 I=1,N
      DO 50 J=5,8
      IF((MTYP(I).NE.0).OR.(J.EQ.5)) THEN
         SY(J)=STEP(RELAX,ATOM(J,I),LATOM(J,I),Z)
         PATOM(J,I)=PATOM(J,I)+SY(J)
         SIGMA(J)=Z
      ELSE
         PATOM(J,I)=0
         SY(J)=0
         SIGMA(J)=0
      END IF
   50 CONTINUE
      IF(MTYP(I).EQ.0) GO TO 80
      Z=0
      SMOM(1)=PATOM(6,I)+PATOM(8,I)*COSBET+PATOM(7,I)*COSGAM
      SMOM(2)=PATOM(7,I)+PATOM(6,I)*COSGAM+PATOM(8,I)*COSALF
      SMOM(3)=PATOM(8,I)+PATOM(7,I)*COSALF+PATOM(6,I)*COSBET
      DO 70 J=1,3
      DO 70 K=1,3
      LJ=LATOM(J+5,I)
      LK=LATOM(K+5,I)
      X1=0
      IF(LJ*LK.NE.0) X1=SMM(LJ,LK)*ATOM(J+5,I)*ATOM(K+5,I)
   70 Z=Z+SMOM(J)*SMOM(K)*X1
      Y=PATOM(6,I)**2+PATOM(7,I)**2+PATOM(8,I)**2+
     *  2*(PATOM(7,I)*PATOM(8,I)*COSALF+PATOM(6,I)*PATOM(8,I)*COSBET+
     *     PATOM(6,I)*PATOM(7,I)*COSGAM)
      Z=SQRT(Z/Y)
      Y=SQRT(Y)
      YY=Y
      ZZ=Z
      GO TO 90
   80 YY=0
      ZZ=0
   90 WRITE(6,1008) ATEXT(I),(PATOM(J,I),SY(J),SIGMA(J),J=5,8),YY,
     *              YY-OLD,ZZ
      OLD=YY
*
*     Scale factor update.
*
      PINSTR(2)=PINSTR(2)+STEP(RELAX,AINSTR(2),LINSTR(2),Z)
      X=1/PINSTR(2)
      Y=X-SCALE
      Z=X*X*Z
      SCALE=X
      WRITE(6,1009) X,Y,Z
*
*     Overall temperature factor update.
*
      Y=STEP(RELAXB,ACRYST(7),LCRYST(7),Z)
      PCRYST(7)=PCRYST(7)+Y
      WRITE(6,1010) PCRYST(7),Y,Z
*
*     Zeropoint update.
*
      WRITE(6,1011)
      DO 100 J=9,10
      Y=STEP(0.8,AINSTR(J),LINSTR(J),Z)
      PINSTR(J)=PINSTR(J)+Y
      WRITE(6,1012) PINSTR(J),Y,Z
  100 CONTINUE
*
*     Halfwidth parameters update.
*
      WRITE(6,1013)
      DO 110 J=3,8
      Y=STEP(0.8,AINSTR(J),LINSTR(J),Z)
      PINSTR(J)=PINSTR(J)+Y
      WRITE(6,1014) PINSTR(J),Y,Z
  110 CONTINUE
*
*     Cell constants update.
*
      WRITE(6,1015)
      DO 120 J=1,6
      Y=STEP(0.8,ACRYST(J),LCRYST(J),Z)
      PCRYST(J)=PCRYST(J)+Y
  120 WRITE(6,1016) PCRYST(J),Y,Z
*
*     Asymmetry parameter update.
*
      Y=STEP(0.8,AINSTR(1),LINSTR(1),Z)
      PINSTR(1)=PINSTR(1)+Y
      WRITE(6,1017) PINSTR(1),Y,Z
*
*     Texture parameters update.
*
      DO 130 J=8,22
      Y=STEP(RELAXB,ACRYST(J),LCRYST(J),Z)
      PCRYST(J)=PCRYST(J)+Y
  130 WRITE(6,1016) PCRYST(J),Y,Z
      IF(TYPE) CALL DIRECT(SZ)
      RETURN
 1003 FORMAT('0NEW PARAMETERS, SHIFTS, AND STANDARD DEVIATIONS=',//,
     1       ' ATOM',7X,'X',7X,'DX',6X,'SX',9X,'Y',7X,'DY',6X,'SY',9X,
     2       'Z',7X,'DZ',6X,'SZ',9X,'B',7X,'DB',6X,'SB')
 1004 FORMAT(1X,A4,3X,4(3F8.5,3X))
 1005 FORMAT('0ATOM  B11   DB11   SB11    B22   DB22   SB22    B33   ',
     1       'DB33   SB33    B12   DB12   SB12    B13   DB13   SB13  ',
     2       '  B23   DB23   SB23')
 1006 FORMAT(1X,A3,18F7.4)
 1007 FORMAT('0ATOM    N',6X,'DN',6X,'SN',7X,'KX',5X,'DKX',5X,'SKX',7X,
     1'KY',5X,'DKY',5X,'SKY',7X,'KZ',5X,'DKZ',5X,'SKZ',8X,'M',6X,'DM',
     2 6X,'SM')
 1008 FORMAT(1X,A3,15(3F8.5,1X))
 1009 FORMAT('0OVERALL SCALE FACTOR=',3F8.4)
 1010 FORMAT(' OVERALL TEMP. FACTOR=',3F8.4)
 1011 FORMAT('0ZEROPOINT=')
 1012 FORMAT(1X,3F11.4)
 1013 FORMAT('0HALFWIDTH PARAMETERS=')
 1014 FORMAT(1X,3F11.2)
 1015 FORMAT('0CELL CONSTANTS=')
 1016 FORMAT(1X,3F11.7)
 1017 FORMAT('0ASYMMETRY PARAMETER=',/,1X,3F11.7,//,
     *       ' TEXTURE PARAMETERS=')
      END
