      COMPLEX FUNCTION CERF(Z)
      COMPLEX Z
*
*     This program calculates the real and the imaginary part of
*     function
*
*        w(z) = Exp(-z*z) * Erfc(z),
*
*     that is, the complex error function, using a series expansion
*     in terms of the imaginary argument.
*
*     Subroutine referenced: FUNCTION DAWSON, for Dawson's integral.
*
      COMPLEX VALUE
      REAL DU,DV,X,YI,SU,SV,U,V,U0,V0,U1,V1,DAWSON,SQRPI,CUT
      INTEGER I
      DATA SQRPI/1.772453851/,CUT/5.0E-9/
*
      X=REAL(Z)
      U0=SQRPI*EXP(-X*X)
      V0=2*DAWSON(X)
      U1=-2*X*U0 
      V1=2*(1-X*V0)
      I=1
      YI=1
      VALUE=CMPLX(U0,V0)
      SU=1
      SV=1
10    SU=-SU
      U=SU*V1
      V=SV*U1
20    YI=YI*AIMAG(Z)/I
      DU=U*YI
      DV=V*YI
      IF(ABS(DU) .LE. CUT .AND. ABS(DV) .LE. CUT) GO TO 30
      VALUE=VALUE+CMPLX(DU,DV)
      U=U1
      U1=-2*(I*U0+X*U1)
      U0=U
      V=V1
      V1=-2*(I*V0+X*V1)
      V0=V
      I=I+1
      IF(MOD(I,2) .NE. 0) GO TO 10
      SV=-SV
      U=SU*U1
      V=SV*V1
      IF(I .LE. 30) GO TO 20
*
30    CERF=VALUE/SQRPI
      RETURN
      END
