#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Rand.h"
#include "erfi.h"

Rand::Rand() : error(0), normal(0), seed(0), integer(0),
	       mean(0.0), variance(1.0)
{
}

Rand::~Rand()
{
	delete error;
}

void
Rand::SetError(const char *err)
{
	delete error;
	error = new char[strlen(err) + 1];
	assert(error != 0);
	strcpy(error, err);
}

double
Rand::GetNumber()
{
	double val, width;

// generate a random number between -1 and 1
	val = 2.0 * (double)rand() / (double)RAND_MAX - 1.0; 

// push it through the inverse error function to get normal distribution
	if (normal) {
		val = M_SQRT2 * erfi(val);
		width = sqrt(variance);
	} else {
		width = variance;
	}
	
// scale to get width or standard deviation, then add mean
	val *= width;
	val += mean;

// and force it to be an integer, if requested
	if (integer)
		val = (double) ((int) val);

	return (val);
}
