// waveshap.h
/*
 * SPKitWaveShaper - an interpolating waveshaping class
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#ifndef _SPKIT_WAVESHAPER_H_
#define _SPKIT_WAVESHAPER_H_

#include "processo.h"
#include "reader.h"

class SPKitWaveShaper : public SPKitProcessor {
public:
    SPKitWaveShaper() { buffer = 0; size = 0; }
    ~SPKitWaveShaper() {
	if (buffer)
	    delete [] buffer;
    }
    
    SPKitError setInputAndBuffer(SPKitProcessor* ip, SPKitReader* bufInput);
    
    int getSample(SPKitSample& outputSample);

protected:
    SPKitInt size;
    SPKitInt halfSize;
    SPKitSample* buffer;
    SPKitSample maxValue;
    SPKitSample minValue;
};

#endif
