// waveshap.cc

#include "waveshap.h"

SPKitError SPKitWaveShaper::setInputAndBuffer(SPKitProcessor* ip,
					      SPKitReader* bip)
{
    SPKitSample bufSample;
    
    SPKitProcessor::setInput(ip);
    
    bip->setOutput(this);
    size = bip->getSampleCount();
    buffer = new SPKitSample[size];
    
    for (int i = 0; bip->getSample(bufSample) && i < size; i++)
	buffer[i] = bufSample;

    minValue = buffer[0];
    maxValue = buffer[size-1];
    halfSize = size / 2;
    
    return 0;
}

int SPKitWaveShaper::getSample(SPKitSample& outputSample)
{
    SPKitSample inputSample;
    
    if (!input->getSample(inputSample))
	return 0;
	
    if (inputSample <= minValue) {
    	outputSample = minValue;
	return 1;
    } else if (inputSample >= maxValue) {
    	outputSample = maxValue;
	return 1;
    }

    SPKitSample scaledSample = (inputSample + 1) * halfSize;
    SPKitInt index1 = int(scaledSample);
    SPKitSample reminder = scaledSample - index1;
    SPKitInt index2 = index1 + 1;
    
    outputSample = buffer[index1] + (buffer[index2]-buffer[index1]) * reminder;
    
    return 1;
}

