// sgireade.h
/*
	Copyright (c) 1995 Kai Lassfolk
*/

#ifndef _SPKIT_READER_H_
#define _SPKIT_READER_H_

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include <dmedia/audiofile.h>

#include "processo.h"
#include "machine.h"

class SPKitReader : public SPKitProcessor {
public:
    SPKitReader();
    ~SPKitReader();

    int setInput(const char*);

    int getSample(SPKitSample&);

    SPKitProcessor* getInput();
    int getSampleCount() const;
    virtual int getSamplesLeft() const;
    
protected:
    int fd;
    
    SPKitInt sampleCount;
    SPKitInt samplesLeft;
    SPKitInt sampleIndex;
    SPKitInt samplesRead;
    
    static SPKitSample int16MaxDenom;

    AFfilehandle audioFile;
    long sampleWidth;
    long sampleType;
    int	samplesPerBuffer;
    int	framesPerBuffer;
    int framesPerTrack;

    int16	*sampleBuffer;
    long	compression;		/* audio data compression type */
};

inline SPKitProcessor* SPKitReader::getInput()
{
    return 0;
}

inline int SPKitReader::getSampleCount() const
{
    return sampleCount;
}

inline int SPKitReader::getSamplesLeft() const
{
    return samplesLeft;
}

#endif
