// resonato.h
/*
    Copyright (c) 1995 Kai Lassfolk
*/

#ifndef _SPKIT_RESONATOR_H_
#define _SPKIT_RESONATOR_H_

#include "processo.h"

class SPKitResonator : public SPKitProcessor {
public:
    ~SPKitResonator();
    
    SPKitError setInput(SPKitProcessor*);

    void setCenterFreqAndBW(SPKitFloat f, SPKitFloat bw);

    int getSample(SPKitSample&);
    
protected:
    SPKitFloat centerFreq;
    SPKitFloat bandwidth;
    
    // Temporary variables needed by derived classes:
    SPKitFloat C;
    
    int channelIndex;

    SPKitFloat a0;
    SPKitFloat b1;
    SPKitFloat b2;

    struct SPKitSampleBuffer {
    	SPKitSample y1;
    	SPKitSample y2;
    };

    SPKitSampleBuffer* chBuf[256];
};

#endif
