/* newsndhe.c */
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include "header.h"

SndHeader *newSndHeader(double samplingRate, int channelCount, int dataFormat)
{
    SndHeader *hp;
    int i;

    if ((hp = (SndHeader *) malloc(sizeof(SndHeader))) == NULL)
	return NULL;

    hp->magicNumber = SND_MAGIC_NUMBER;
    hp->headerSize = sizeof(SndHeader);
    hp->dataSize = 0;
    hp->dataFormat = dataFormat;
    hp->samplingRate = samplingRate;
    hp->channelCount = channelCount;

    for (i = 0; i < 4; i++)
	hp->info[i] = '\0';

    return hp;
}
