// genwrite.h
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#ifndef _SPKIT_WRITER_H_
#define _SPKIT_WRITER_H_

#include <stdio.h>
extern "C" {
#include <stdlib.h>
#include "header.h"
};
#include "processo.h"

class SPKitWriter : public SPKitProcessor {
public:
    SPKitWriter();
    ~SPKitWriter();
    
    int setInputOutput(SPKitProcessor*, const char*);
    
    void run(); // run until end of input
    int runFor(SPKitInt); // run for specified amount of samples
    
    int getSample(SPKitSample&);

    virtual int32 getSamplesWritten() const;

protected:
    FILE *filePtr;
    SndHeader *fileHeader;
    
    int32 samplesWritten;
};

inline int32 SPKitWriter::getSamplesWritten() const
{
    return samplesWritten;
}

inline int SPKitWriter::getSample(SPKitSample& outputSample)
{
    return 0;
}

#endif
