// genreade.h
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#ifndef _SPKIT_READER_H_
#define _SPKIT_READER_H_

#include "processo.h"
#include <stdio.h>
#include "machine.h"

class SPKitReader : public SPKitProcessor {
public:
    SPKitReader();
    ~SPKitReader();

    virtual SPKitError setInput(const char*);

    int getSample(SPKitSample&);

    SPKitProcessor* getInput();
    virtual int32 getSampleCount() const;
    virtual int32 getSamplesLeft() const;
    
protected:
    FILE *filePtr;
    int32 sampleCount;
    int32 samplesLeft;
    
    static SPKitSample shrtMaxDenom;
};

inline SPKitProcessor* SPKitReader::getInput()
{
    return 0;
}

inline int32 SPKitReader::getSampleCount() const
{
    return sampleCount;
}

inline int32 SPKitReader::getSamplesLeft() const
{
    return samplesLeft;
}

#endif
