// feedback.cc

#include "feedback.h"

int SPKitFeedback::setInput(SPKitProcessor* p)
{
    if (SPKitProcessor::setInput(p) != 0)
	return -1;

    feedbackTime = 0;
    feedbackSampleCount = 0;
    feedbackSampleIndex = 0;
    haveInput = 1;
    feedbackInput = 0;

    return 0;
}

void SPKitFeedback::setFeedbackInput(SPKitProcessor* sp)
{
    feedbackInput = sp;
    feedbackInput->setOutput(this);
}

void SPKitFeedback::setFeedbackTime(SPKitFloat t)
{
    feedbackTime = t;
    feedbackSampleCount = int(feedbackTime * inputSamplingRate) *
    			  inputChannelCount;
}

int SPKitFeedback::getSample(SPKitSample& outputSample)
{
    SPKitSample feedbackSample;

    outputSample = 0.0;

    if (haveInput)
	haveInput = input->getSample(outputSample);

    if (haveInput || feedbackSampleIndex < feedbackSampleCount) {
	if (feedbackInput->getSample(feedbackSample)) {
	    outputSample += feedbackSample;
	    if (haveInput == 0)
		feedbackSampleIndex++;
	} else
	    feedbackSampleIndex = feedbackSampleCount;
	return 1;
    } else
	return 0;
}

double SPKitFeedback::getFeedbackTime() const
{
    return feedbackTime;
}
