// dynamics.h
/*
    Copyright (c) 1995 Kai Lassfolk
*/

#ifndef _SPKIT_DYNAMICSPROCESSOR_H_
#define _SPKIT_DYNAMICSPROCESSOR_H_

#include "processo.h"

class SPKitDynamicsProcessor : public SPKitProcessor {
public:
    virtual SPKitError setInputAndEstimationTime(SPKitProcessor*, SPKitFloat);
    
    virtual void setThreshold(SPKitFloat);

    int getSample(SPKitSample& outputSample);
    virtual SPKitFloat getThreshold() const;

protected:
    virtual void scaleBuffer() = 0;
    
    SPKitSample* sampleBuffer;

    SPKitSample absMax1;
    SPKitSample absMax2;
    
    SPKitInt bufSize;
    SPKitInt halfInputBufSize;
    SPKitInt inputBufSize;
    
    SPKitInt readIndex;
    SPKitInt writeIndex;
    SPKitInt processIndex;
    
    SPKitFloat threshold;
    
    SPKitInt endOfInput;
    SPKitInt firstTime;
};

inline void SPKitDynamicsProcessor::setThreshold(SPKitFloat value)
{
    threshold = value > 0.0 ? value : 0.00001;
}

inline SPKitFloat SPKitDynamicsProcessor::getThreshold() const
{
    return threshold;
}

#endif
