// bwhighpa.cc

#include "bwhighpa.h"
#include <math.h>

void SPKitBWHighPassFilter::setCutOffFreq(SPKitFloat f)
{
    cutOffFreq = f;
    
    C = tan(M_PI * cutOffFreq / inputSamplingRate);

    a[0] = 1.0 / (1.0 + sqrt(2.0) * C + C * C);
    a[1] = -2.0 * a[0];
    a[2] = a[0];

    b[0] = 2 * (C * C - 1.0) * a[0];
    b[1] = (1.0 - sqrt(2.0) * C + C * C) * a[0];
}
