// butterwo.h
/*
    Copyright (c) 1994 Kai Lassfolk
*/

#ifndef _SPKIT_BUTTERWORTH_H_
#define _SPKIT_BUTTERWORTH_H_

#include "processo.h"

class SPKitButterworthFilter : public SPKitProcessor {
public:
    ~SPKitButterworthFilter();
    
    SPKitError setInput(SPKitProcessor*);

    int getSample(SPKitSample&);

protected:
    SPKitFloat cutOffFreq;

    // Temporary variables needed by derived classes:
    SPKitFloat C;
    SPKitFloat D;
    
    int channelIndex;

    SPKitFloat a[3];
    SPKitFloat b[2];

    struct BWBuffer {
    	SPKitSample x[2];
    	SPKitSample y[2];
    };

    BWBuffer* chBuf[256];
};

#endif
