// testcomb.cc
/*
 * testcomb: a simple SoundProcessor Kit program
 * Copyright (c) 1995 Janne Halmkrona
 */

#include <stdio.h>
#include <spkit/spkit.h>
#include "comb.h"

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitComb comb;
    SPKitWriter writer;
    double time;

    if (argc != 4) {
	fprintf(stderr, "Usage: rev rev.time sourcefile destfile\n");
	exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[2]); 			// Open source soundfile
    comb.setInputAndDelayTime(&reader, 0.05); // Set reader as input to comb
    writer.setInputOutput(&comb, argv[3]); 	// Set comb as input to writer
					    	// and open destination soundfile
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &time);
    comb.setReverbTime(time); 			// Set reverb time

    /*
     * Run
     */
    writer.run();

    exit(0);
}
