// z1lpf.h

#ifndef _SPKIT_Z1LOWPASSFILTER_H_
#define _SPKIT_Z1LOWPASSFILTER_H_

#include <spkit/spkit.h>

class SPKitZ1LowPassFilter : public SPKitProcessor {
public:
    SPKitZ1LowPassFilter();
    ~SPKitZ1LowPassFilter();

    int setInput(SPKitProcessor* input);
    void setG(SPKitFloat g);

    int getSample(SPKitSample& outputSample);
    SPKitFloat getG() const;

protected:
    SPKitSample* buf;
    int channelIndex;

    SPKitFloat g;
};

inline void SPKitZ1LowPassFilter::setG(SPKitFloat newG)
{
    g = newG;
}
inline SPKitFloat SPKitZ1LowPassFilter::getG() const
{
    return g;
}

#endif
