// jamrvb.cc
/*
 * jamrvb: an experimental reverberator
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>
#include "jamrever.h"

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitJAMReverb reverb;
    SPKitWriter writer;
    SPKitMux mux;
    SPKitBWLowPassFilter lpf;
    SPKitAmp ampDirect;
    SPKitAmp ampReverb;
    SPKitSum sum;
    
    double rvbLevel;
    double revLevel;
    double dryLevel;
    double reverbTime;

    if (argc != 7) {
	fprintf(stderr, "Usage: jamrvb time revlevel rvblevel drylevel sourcefile destfile\n");
	exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[5]); // Open source soundfile
    mux.setInput(&reader);
    ampDirect.setInput(&mux);
    lpf.setInput(&mux);
    reverb.setInput(&lpf);  // Set reader as input to fader
    ampReverb.setInput(&reverb);
    sum.setInput(&ampDirect);
    sum.addInput(&ampReverb);
    writer.setInputOutput(&sum, argv[6]); // Set fader as input to writer
					    // and open destination soundfile
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &reverbTime);
    reverb.setReverbTime(reverbTime);
    
    sscanf(argv[2], "%lf", &revLevel);
    sscanf(argv[3], "%lf", &rvbLevel);
    sscanf(argv[4], "%lf", &dryLevel);
    ampDirect.setGain(dryLevel);
    ampReverb.setGain(revLevel);
    reverb.setReverbLevel(rvbLevel);
    lpf.setCutOffFreq(6000);
    
    /*
     * Run
     */
    writer.run();

    exit(0);
}
