// jamrever.cc

#include "jamrever.h"

SPKitError SPKitJAMReverb::setInput(SPKitProcessor* ip)
{
    m0.setInput(ip);
    a0.setInput(&m0);
    a0.setGain(1.0);
    pdsum.setInput(&a0);

#if 0    
    lpf.setInput(&m0);
    lpf.setG(0.35);
    lpfa.setInput(&lpf);
    lpfa.setGain(0.75);

    pd1.setInputAndDelayTime(&lpfa, 0.0043);
#else
    pd1.setInputAndDelayTime(&m0, 0.0043);
#endif
    m1.setInput(&pd1);
    a1.setInput(&m1);
    a1.setGain(0.841);
    pdsum.addInput(&a1);
    
    pd2.setInputAndDelayTime(&m1, 0.0215 - 0.0043);
    m2.setInput(&pd2);
    a2.setInput(&m2);
    a2.setGain(0.504);
    pdsum.addInput(&a2);
    
    pd3.setInputAndDelayTime(&m2, 0.0225 - 0.0215);
    m3.setInput(&pd3);
    a3.setInput(&m3);
    a3.setGain(0.491);
    pdsum.addInput(&a3);
    
    pd4.setInputAndDelayTime(&m3, 0.0268 - 0.0225);
    m4.setInput(&pd4);
    a4.setInput(&m4);
    a4.setGain(0.379);
    pdsum.addInput(&a4);
    
    pd5.setInputAndDelayTime(&m4, 0.0270 - 0.0268);
    m5.setInput(&pd5);
    a5.setInput(&m5);
    a5.setGain(0.380);
    pdsum.addInput(&a5);
    
    pd6.setInputAndDelayTime(&m5, 0.0298 - 0.0270);
    m6.setInput(&pd6);
    a6.setInput(&m6);
    a6.setGain(0.346);
    pdsum.addInput(&a6);
    
    pd7.setInputAndDelayTime(&m6, 0.0458 - 0.0298);
    m7.setInput(&pd7);
    a7.setInput(&m7);
    a7.setGain(0.289);
    pdsum.addInput(&a7);
    
    pd8.setInputAndDelayTime(&m7, 0.0485 - 0.0458);
    m8.setInput(&pd8);
    a8.setInput(&m8);
    a8.setGain(0.272);
    pdsum.addInput(&a8);
    
    pd9.setInputAndDelayTime(&m8, 0.0572 - 0.0485);
    m9.setInput(&pd9);
    a9.setInput(&m9);
    a9.setGain(0.192);
    pdsum.addInput(&a9);
    
    pd10.setInputAndDelayTime(&m9, 0.0587 - 0.0572);
    m10.setInput(&pd10);
    a10.setInput(&m10);
    a10.setGain(0.193);
    pdsum.addInput(&a10);
    
    pd11.setInputAndDelayTime(&m10, 0.0595 - 0.0587);
    m11.setInput(&pd11);
    a11.setInput(&m11);
    a11.setGain(0.217);
    pdsum.addInput(&a11);
    
    pd12.setInputAndDelayTime(&m11, 0.0612 - 0.0595);
    m12.setInput(&pd12);
    a12.setInput(&m12);
    a12.setGain(0.181);
    pdsum.addInput(&a12);
    
    pd13.setInputAndDelayTime(&m12, 0.0707 - 0.0612);
    m13.setInput(&pd13);
    a13.setInput(&m13);
    a13.setGain(0.180);
    pdsum.addInput(&a13);
    
    pd14.setInputAndDelayTime(&m13, 0.0708 - 0.0707);
    m14.setInput(&pd14);
    a14.setInput(&m14);
    a14.setGain(0.181);
    pdsum.addInput(&a14);
    
    pd15.setInputAndDelayTime(&m14, 0.0726 - 0.0708);
    m15.setInput(&pd15);
    a15.setInput(&m15);
    a15.setGain(0.176);
    pdsum.addInput(&a15);
    
    pd16.setInputAndDelayTime(&m15, 0.0741 - 0.0726);
    m16.setInput(&pd16);
    a16.setInput(&m16);
    a16.setGain(0.142);
    pdsum.addInput(&a16);
    
    pd17.setInputAndDelayTime(&m16, 0.0753 - 0.0741);
    m17.setInput(&pd17);
    a17.setInput(&m17);
    a17.setGain(0.167);
    pdsum.addInput(&a17);
    
    pd18.setInputAndDelayTime(&m17, 0.0797 - 0.0753);
    a18.setInput(&pd18);
    a18.setGain(0.134);
    pdsum.addInput(&a18);
    
    pdmux.setInput(&pdsum);
    outsum.setInput(&pdmux);

    reverb.setInput(&pdmux);
    reverb.setReverbTime(2.0);
    rd.setInputAndDelayTime(&reverb, 0.0797 - 0.050);
    ra.setInput(&rd);
    ra.setGain(0.7);
    outsum.addInput(&ra);

    return SPKitProcessor::setInput(&outsum);
}

void SPKitJAMReverb::setReverbTime(SPKitFloat rt)
{
    reverb.setReverbTime(rt);
}

void SPKitJAMReverb::setReverbLevel(SPKitFloat level)
{
    ra.setGain(level);
}
