// reverb.cc
/*
 * reverb: a simple reverberator
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>
#include "comblowp.h"

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitCombLowPass comb;
    SPKitWriter writer;
    double gain;

    if (argc != 3) {
	fprintf(stderr, "Usage: reverb sourcefile destfile\n");
	exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[1]); // Open source soundfile
    comb.setInputAndDelayTime(&reader, 0.050);  // Set reader as input to fader
    writer.setInputOutput(&comb, argv[2]); // Set fader as input to writer
					    // and open destination soundfile
    /*
     * Setup processing parameters
     */
    comb.setG1(0.46);
    comb.setG(0.83);

    /*
     * Run
     */
    writer.run();

    exit(0);
}
