// lim.cc
/*
 * lim: a limiter example
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char* argv[])
{
    SPKitReader reader;
    SPKitAmp amp;
    SPKitLimiter dyn;
    SPKitWriter writer;
    double gain;

    if (argc != 4) {
	fprintf(stderr, "Usage: lim gain sourcefile destfile\n");
	return 1;
    }

    if (reader.setInput(argv[2]) < 0) {
	fprintf(stderr, "lim: cannot open input: %s\n", argv[2]);
	return 1;
    }
    amp.setInput(&reader);
    dyn.setInputAndEstimationTime(&amp, 0.05);
    if (writer.setInputOutput(&dyn, argv[3]) < 0) {
	fprintf(stderr, "lim: cannot open input: %s\n", argv[3]);
	return 1;
    }

    sscanf(argv[1], "%lf", &gain);
    amp.setGain(gain);

    writer.run();

    return 0;
}
