// comp.cc
/*
 * comp: a compressor example
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char* argv[])
{
    SPKitReader reader;
    SPKitAmp amp;
    SPKitCompressor comp;
    SPKitWriter writer;
    double gain;
    double threshold;
    double ratio;

    if (argc != 6) {
	fprintf(stderr, "Usage: comp gain threshold comp-ratio");
	fprintf(stderr, " sourcefile destfile\n");
	return 1;
    }

    if (reader.setInput(argv[4]) < 0) {
	fprintf(stderr, "comp: cannot open input: %s\n", argv[4]);
	return 1;
    }
    amp.setInput(&reader);
    comp.setInputAndEstimationTime(&amp, 0.05);
    if (writer.setInputOutput(&comp, argv[5]) < 0) {
	fprintf(stderr, "comp: cannot open output: %s\n", argv[5]);
	return 1;
    }

    sscanf(argv[1], "%lf", &gain);
    amp.setGain(gain);
    sscanf(argv[2], "%lf", &threshold);
    comp.setThreshold(threshold);
    sscanf(argv[3], "%lf", &ratio);
    comp.setRatio(ratio);

    writer.run();

    return 0;
}
