// hpbw.m
// hpbw: a Butterworth high-pass filter command
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader source;
    SPKitBWHighPassFilter hpbw;
    SPKitWriter dest;
    double freq;

    if (argc != 4) {
	fprintf(stderr, "Usage: hpbw cutOffFreq source dest\n");
	exit(1);
    }

    if (source.setInput(argv[2]) < 0) {
	fprintf(stderr, "hpbw: cannot open input: %s\n", argv[2]);
	exit(1);
    }
    hpbw.setInput(&source);
    if (dest.setInputOutput(&hpbw, argv[3]) < 0) {
	fprintf(stderr, "hpbw: cannot open output: %s\n", argv[3]);
	exit(1);
    }

    sscanf(argv[1], "%lf", &freq);
    hpbw.setCutOffFreq(freq);

    dest.run();

    exit(0);
}
