/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* set audio chip to/from A-law (SAU) */

#define AUDIO_CHIP

#include <stdio.h>
#include <sys/ioctl.h>
#include <sun/audioio.h>
#include <sbusdev/audio_79C30.h>

#ifdef MAIN
	
char buff[1000];

main(argc,argv)
int argc;
char **argv;
	{
	int direction;
	int n;
	int fd;

	if (argc < 2) {
		fprintf(stderr,"usage: %s < alaw.au  out\n",*argv);
		fprintf(stderr,"usage: %s > alaw.au  in\n",*argv);
		exit(0);
		}
	if (*argv[1] == 'i')
		direction = 0;
	else
		direction = 1;
	fd = open("/dev/audio",direction);
	set_alaw(fd,1);
	if (direction) 
		while((n=read(0,buff,1000)) > 0)
			write(fd,buff,n);
	else
		while((n=read(fd,buff,1000)) > 0)
			write(1,buff,n);
	}

#endif


int
set_alaw(fd,how)
int fd;		/* dev/audio */
int how;		/* on or off */
	{
	struct audio_ioctl regs;
	int old;

	regs.control = AUDIO_MAP_MMR1;
	if (ioctl(fd,AUDIOGETREG,&regs)<0)
		perror("ioctl AUDIOGETREG");

	old = regs.data[0]&1;

	if ((old^how)&1) {
		regs.data[0] ^= 1;
		if (ioctl(fd,AUDIOSETREG,&regs)<0)
			perror("ioctl AUDIOSETREG");
		}
	return(old);
	}
