#!/bin/wish -f
# sample reverb interface

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set cmd ./reverb
set control [open |$cmd "r+"]
#set control [open "|sh -c $cmd 2> /dev/console" "r+"]
puts stderr "starting $cmd, waiting for response..."
gets $control foo
puts stderr "Starting"

# do a slider command

set d1 "0"; set d2 "0"; set g1 "0"; set g2 "0"
proc slide {var value} {
	global d1 g1 d2 g2

	set $var $value
	do "R $d1 $g1 $d2 $g2"
	}

# send a command to the filter, display the result

proc do {s} {
	global control message

	puts $control "$s"
	flush $control
	gets $control message
	}

# select /dev/audio as input file

proc audio {} {
	global message filename

	set message "reading input from /dev/audio"
	set filename ""
   do "F/dev/audio"
	}

# manage the file name

set curr_dir [pwd] 
proc check_file {name} {
   global message curr_dir filename

   if {[file isdirectory $name]} {
      set message "Changing to directory $curr_dir/$name"
      set curr_dir $curr_dir/$name
      cd $name
		set filename ""
      return 0
      }
   if {![file exists "$name"]} {
      set message "File $name does not exist"
      return 0
      }
   do "F$curr_dir/$name"
   return 1
   }

wm title . "Echo demo"
frame .top
label .top.lab -text file:
button .top.start -text "start" -relief raised -command \
	{do +;set message running}
button .top.stop -text  "stop" -relief raised -command \
	{do -;set message stopped}
button .top.quit -text  "quit" -relief raised -command {do Q; destroy .}
entry .top.file -textvariable filename -width 25 -border 3 -relief raised
bind  .top.file <KeyPress-Return> {check_file $filename}    
bind  .top.file <Button-2> audio

pack append .top \
		.top.lab {left} \
		.top.file {left fillx expand} \
		.top.start {left} \
		.top.stop {left} \
		.top.quit {left}

scale .d1 -orient horiz -to 8000 -from 100 \
	-command "slide d1" -label "Sample Delay"
scale .g1 -orient horiz -to 700 -from 0 \
	-command "slide g1" -label "gain"
# scale .d2 -orient horiz -to 8000 -from 100 \
	-command "slide d2" -label "Sample Delay"
# scale .g2 -orient horiz -to 700 -from 0 \
	-command "slide g2" -label "Gain"

label .bottom -textvariable message

pack append . .top {top fillx} \
				.d1 {top fillx expand} \
				.g1 {top fillx expand} \
				.bottom {bottom fillx expand}
bind . <Control-c> {puts $control Q; destroy .}

set message "Stopped"
