/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

#define d define
#d signed
#d Type typedef struct
#ifndef u_char
#define u_char	unsigned char
#define u_short unsigned short
#endif
#ifndef	UCH
#d UCH(ch)	((u_char) (ch))
#endif
#d MIDI_MAX_CHANS	16	/* maximum midi channels */
#d MIDI_NUM_KEYS	128	/* number of midi key values */

/* masks */
#d M_CMD	0x80		/* midi command bit mask */
#d M_CMD_MASK	0xF0		/* midi command mask */
#d M_CHAN_MASK	0x0F		/* midi channel mask */
#d M_VAL_MASK	0x7F		/* midi value mask */

/* command ids */
/* CH_... channel commands */
#d CH_KEY_OFF	0x80		/* channel key off */
#d CH_KEY_ON	0x90		/* channel key on */
#d CH_POLY_KPRS	0xA0		/* polyphonic key pressure */
#d CH_CTL	0xB0		/* channel control */
#d CH_PRG	0xC0		/* channel program change */
#d CH_PRESSURE	0xD0		/* channel pressure */
#d CH_P_BEND	0xE0		/* channel pitch bend */

/* SX_... system exclusive commands */
#d SX_CMD	0xF0		/* system exclusive command */
#d SX_EOB	0xF7		/* system exclusive end of block */

/* SC_... system common commands */
#d SC_MSEL	0xF2		/* system common measure select */
#d SC_SSEL	0xF3		/* system common song select */
#d SC_TSEL	0xF6		/* system common tune request */

/* RT_... realtime commands */
#d RT_TCLOCK	0xF8		/* timing clock */
#d RT_START	0xFA		/* start (at first measure) */
#d RT_CONT	0xFB		/* continue */
#d RT_STOP	0xFC		/* stop */
#d RT_ASENSE	0xFE		/* active sensing */
#d RT_RESET	0xFF		/* system reset */

#d ID_MISC	0x00		/* manuf ID for misc companies (needs SUBID) */
#d SUBID(x,y)	(((x)<<8)|(y))
#d SUBID_HEADER	SUBID(0x7F,0x7F) /* fake manuf SUBID for headers */

/* default for reading/writing under regular UNIX */

/* template for all midi parametric data */
/* note: watch out for synth. parameters that exceed u_char range! */
Type midi_par {
	u_char par_index;	/* index in hardware table */
	u_char par_val;		/* current value */
	u_char par_ub;		/* upper boundary */
	char *par_name;		/* name */
} MidiPar;

/* same as above, but for parameters requiring u_short storage */
Type midi_spar {
	u_short par_index;	/* index in hardware table */
	u_short par_val;	/* current value */
	u_short par_ub;		/* upper boundary */
	char *par_name;		/* name */
} MidiSpar;

#d TRW_SEL_TTY	1
#d TRW_SEL_RFD	2
#d TRW_SEL_WFD	3

/* struct for status/command byte information in statinfo.c */
struct	statstr	{
	signed char	clen;	/* number of command bytes */
	u_char	flgs;		/* misc. info, see below */
};			/* bits for flgs */
#d RSSET	1		/* Running Status SET by this command */
#d RSCLR	2		/* Running Status CLeaRed by this command */
#d RSNOP	4		/* Running Status unaffected by this command */
#d UNDF		8		/* Not defined in the MIDI spec */

#ifndef	MIDI_EOX
#d MIDI_EOX(b)		(((b)&M_CMD)&&(b)<0xF8&&(b)!=SX_CMD)
#endif
#d MIDI_RT(b)		((b)>=0xF8)
#undef d
