#!/bin/wish -f
# send an Alaw/Mu-law command to the synthesizer 

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set command ""
set result "type a synth command"

# find a "synth" interpreter"

set interps [winfo interps]
set indx [lsearch $interps "synth*"]
puts stderr "$interps <$indx>"

wm title . "Codec Setting"
wm iconname . "law"
wm geometry . +200+30

set law 0
frame .f -relief raised 
radiobutton .f.mu -text "mu-law" -value 0 -variable law \
		-selector "red" -command "send_synth"
radiobutton .f.a -text "A-law" -value 1 -variable law \
		-selector "red" -command "send_synth"
button .f.q -text "quit" -command "destroy ."

pack append .f .f.a {left fillx expand} \
					.f.mu {left fillx expand} \
					.f.q  {right fillx expand}
label .l -textvariable result
pack append . .f top .l bottom
set result -

if {$indx == "-1" } {
		set result "No Sparc-O-matic is running to send commands to"
		after 5000
		destroy .
		return
		}

set interp [lindex $interps $indx]

proc send_synth {} {
	global interp result law

	if {$law} {set what A-law} { set what mu-law}
	set command "remote {A=$law} {setting mode to $what}"
	set result [send $interp $command]
	}
